/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.host;

import io.github.oitstack.goblin.runtime.docker.host.DockerHostDiscoverStrategy;
import io.github.oitstack.goblin.runtime.docker.utils.StringUtils;
import io.github.oitstack.goblin.runtime.utils.PropertyAndEnvUtils;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostLocalDiscoverStrategy
implements DockerHostDiscoverStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerHostLocalDiscoverStrategy.class);

    @Override
    public List<String> discover() {
        String dockerHosts = PropertyAndEnvUtils.get("GOBLIN_RUNTIME_DOCKER_HOST");
        if (StringUtils.isBlank(dockerHosts)) {
            LOGGER.error("{} is not configured.", (Object)"GOBLIN_RUNTIME_DOCKER_HOST");
            throw new RuntimeException(String.format("%s is not configured", "GOBLIN_RUNTIME_DOCKER_HOST"));
        }
        return Arrays.asList(dockerHosts.split(","));
    }
}

