/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image;

import com.github.dockerjava.api.DockerClient;
import io.github.oitstack.goblin.runtime.docker.client.AutoRecycleDockerClient;
import io.github.oitstack.goblin.runtime.docker.image.DockerImageName;
import io.github.oitstack.goblin.runtime.docker.image.pull.PullStrategyContext;
import io.github.oitstack.goblin.runtime.docker.image.pull.PullStrategyFactory;
import io.github.oitstack.goblin.runtime.docker.image.pull.strategies.PullStrategy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class DockerImage {
    private DockerImageName imageName;
    protected CompletableFuture<Boolean> pulled;
    private String pullStrategy = "AGE";
    private DockerClient dockerClient;

    public String getPullStrategy() {
        return this.pullStrategy;
    }

    private Boolean pull() {
        PullStrategy pullStrategy = PullStrategyFactory.getInstance().getPullStrategy(this.getPullStrategy());
        return new PullStrategyContext().pull(pullStrategy, this.imageName, this.dockerClient);
    }

    private Boolean hasAlready() {
        try {
            return this.pulled.get(100L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private DockerImage(DockerClient dockerClient, DockerImageName imageName, String pullStrategy) {
        this.dockerClient = dockerClient;
        this.imageName = imageName;
        this.pullStrategy = pullStrategy;
        this.pulled = CompletableFuture.supplyAsync(() -> this.pull());
    }

    public static DockerImage parseFrom(String o) {
        return DockerImage.parseFrom(o, "CACHE");
    }

    public static DockerImage parseFrom(String o, String pullStrategy) {
        return DockerImage.parseFrom(o, pullStrategy, AutoRecycleDockerClient.getInstance());
    }

    public static DockerImage parseFrom(String o, DockerClient dockerClient) {
        return DockerImage.parseFrom(o, "CACHE", dockerClient);
    }

    public static DockerImage parseFrom(String o, String pullStrategy, DockerClient dockerClient) {
        return new DockerImage(dockerClient, DockerImageName.parseFrom(o), pullStrategy);
    }

    public DockerImageName getImageName() {
        return this.imageName;
    }

    public CompletableFuture<Boolean> getPulled() {
        return this.pulled;
    }

    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    public void setImageName(DockerImageName imageName) {
        this.imageName = imageName;
    }

    public void setPulled(CompletableFuture<Boolean> pulled) {
        this.pulled = pulled;
    }

    public void setPullStrategy(String pullStrategy) {
        this.pullStrategy = pullStrategy;
    }

    public void setDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerImage)) {
            return false;
        }
        DockerImage other = (DockerImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DockerImageName this$imageName = this.getImageName();
        DockerImageName other$imageName = other.getImageName();
        if (this$imageName == null ? other$imageName != null : !((Object)this$imageName).equals(other$imageName)) {
            return false;
        }
        CompletableFuture<Boolean> this$pulled = this.getPulled();
        CompletableFuture<Boolean> other$pulled = other.getPulled();
        if (this$pulled == null ? other$pulled != null : !this$pulled.equals(other$pulled)) {
            return false;
        }
        String this$pullStrategy = this.getPullStrategy();
        String other$pullStrategy = other.getPullStrategy();
        if (this$pullStrategy == null ? other$pullStrategy != null : !this$pullStrategy.equals(other$pullStrategy)) {
            return false;
        }
        DockerClient this$dockerClient = this.getDockerClient();
        DockerClient other$dockerClient = other.getDockerClient();
        return !(this$dockerClient == null ? other$dockerClient != null : !this$dockerClient.equals(other$dockerClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DockerImageName $imageName = this.getImageName();
        result = result * 59 + ($imageName == null ? 43 : ((Object)$imageName).hashCode());
        CompletableFuture<Boolean> $pulled = this.getPulled();
        result = result * 59 + ($pulled == null ? 43 : $pulled.hashCode());
        String $pullStrategy = this.getPullStrategy();
        result = result * 59 + ($pullStrategy == null ? 43 : $pullStrategy.hashCode());
        DockerClient $dockerClient = this.getDockerClient();
        result = result * 59 + ($dockerClient == null ? 43 : $dockerClient.hashCode());
        return result;
    }

    public String toString() {
        return "DockerImage(imageName=" + this.getImageName() + ", pulled=" + this.getPulled() + ", pullStrategy=" + this.getPullStrategy() + ", dockerClient=" + this.getDockerClient() + ")";
    }
}

