/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image;

import io.github.oitstack.goblin.runtime.docker.image.DockerImageVersion;
import io.github.oitstack.goblin.runtime.docker.image.namereplacer.NameReplacerChain;
import io.github.oitstack.goblin.runtime.utils.Preconditions;

public class DockerImageName {
    private final String rawName;
    private final String registry;
    private final String repository;
    private final DockerImageVersion version;
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String COLON = ":";
    private static final String SHA_TAG = "@sha256:";
    private static final String LOCAL_HOST = "localhost";

    public static DockerImageName parseFrom(String originImageName) {
        return NameReplacerChain.apply(new DockerImageName(originImageName));
    }

    private DockerImageName(String rawName, String registry, String repository, DockerImageVersion version) {
        this.rawName = rawName;
        this.registry = registry;
        this.repository = repository;
        this.version = version;
    }

    private ImageHubMetaData calcImageHubMetaData(String fullImageName) {
        String beforeSlashStr;
        int index = fullImageName.indexOf(SLASH);
        ImageHubMetaData imageHubMetaData = index == -1 ? new ImageHubMetaData("", fullImageName) : (!(beforeSlashStr = fullImageName.substring(0, index)).contains(DOT) && !beforeSlashStr.contains(COLON) && !beforeSlashStr.equals(LOCAL_HOST) ? new ImageHubMetaData("", fullImageName) : new ImageHubMetaData(fullImageName.substring(0, index), fullImageName.substring(index + 1)));
        return imageHubMetaData;
    }

    private ImageMetaData calcImageMetaData(String remoteName) {
        ImageMetaData imageMetaData = remoteName.contains(SHA_TAG) ? new ImageMetaData(remoteName.split(SHA_TAG)[0], new DockerImageVersion.Sha256Version(remoteName.split(SHA_TAG)[1])) : (remoteName.contains(COLON) ? new ImageMetaData(remoteName.split(COLON)[0], new DockerImageVersion.TagVersion(remoteName.split(COLON)[1])) : new ImageMetaData(remoteName, new DockerImageVersion.AnyVersion()));
        return imageMetaData;
    }

    private DockerImageName(String fullImageName) {
        Preconditions.checkNotBlank(fullImageName, "fullImageName cannot be blank.");
        this.rawName = fullImageName;
        ImageHubMetaData imageHubMetaData = this.calcImageHubMetaData(fullImageName);
        this.registry = imageHubMetaData.getRegistry();
        String remoteName = imageHubMetaData.getRemoteName();
        ImageMetaData imageMetaData = this.calcImageMetaData(remoteName);
        this.version = imageMetaData.getVersion();
        this.repository = imageMetaData.getRepository();
    }

    public String getUnversionedPart() {
        return (this.registry == null || "".equals(this.registry) ? "" : this.registry + SLASH) + this.repository;
    }

    public DockerImageName cloneWithRegistry(String registry) {
        return new DockerImageName(this.rawName, registry, this.repository, this.version);
    }

    public DockerImageName cloneWithRepository(String repository) {
        return new DockerImageName(this.rawName, this.registry, repository, this.version);
    }

    public String toIdentifyName() {
        return this.getUnversionedPart() + this.version.getSeparator() + this.version.getVersionDesc();
    }

    public String getRawName() {
        return this.rawName;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public DockerImageVersion getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerImageName)) {
            return false;
        }
        DockerImageName other = (DockerImageName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rawName = this.getRawName();
        String other$rawName = other.getRawName();
        if (this$rawName == null ? other$rawName != null : !this$rawName.equals(other$rawName)) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        DockerImageVersion this$version = this.getVersion();
        DockerImageVersion other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerImageName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rawName = this.getRawName();
        result = result * 59 + ($rawName == null ? 43 : $rawName.hashCode());
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        DockerImageVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "DockerImageName(rawName=" + this.getRawName() + ", registry=" + this.getRegistry() + ", repository=" + this.getRepository() + ", version=" + this.getVersion() + ")";
    }

    class ImageMetaData {
        private String repository;
        private DockerImageVersion version;

        public ImageMetaData(String repository, DockerImageVersion version) {
            this.repository = repository;
            this.version = version;
        }

        public String getRepository() {
            return this.repository;
        }

        public DockerImageVersion getVersion() {
            return this.version;
        }
    }

    class ImageHubMetaData {
        private String registry;
        private String remoteName;

        public ImageHubMetaData(String registry, String remoteName) {
            this.registry = registry;
            this.remoteName = remoteName;
        }

        public String getRegistry() {
            return this.registry;
        }

        public String getRemoteName() {
            return this.remoteName;
        }
    }
}

