/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image;

import java.util.function.Predicate;

public abstract class DockerImageVersion {
    public static final Predicate TAG_VERSION_PREDICATE = new Predicate<String>(){
        public static final String TAG_REGEX = "[\\w][\\w.\\-]{0,127}";

        @Override
        public boolean test(String o) {
            return o.matches(TAG_REGEX);
        }
    };
    public static final Predicate SHA256_VERSION_PREDICATE = new Predicate<String>(){
        public static final String HASH_REGEX = "[0-9a-fA-F]{32,}";

        @Override
        public boolean test(String o) {
            return o.matches(HASH_REGEX);
        }
    };

    DockerImageVersion(String version) {
        this.support(version);
    }

    public abstract String getSeparator();

    public abstract String getVersionDesc();

    public abstract boolean support(String var1);

    public static class Sha256Version
    extends DockerImageVersion {
        private final String version;

        Sha256Version(String hash) {
            super(hash);
            this.version = hash;
        }

        @Override
        public String getSeparator() {
            return "@";
        }

        @Override
        public String getVersionDesc() {
            return this.version;
        }

        @Override
        public boolean support(String version) {
            return SHA256_VERSION_PREDICATE.test(version);
        }
    }

    public static class TagVersion
    extends DockerImageVersion {
        static final TagVersion LATEST = new TagVersion("latest");
        private final String version;

        TagVersion(String tag) {
            super(tag);
            this.version = tag;
        }

        @Override
        public String getSeparator() {
            return ":";
        }

        @Override
        public String getVersionDesc() {
            return this.version;
        }

        @Override
        public boolean support(String version) {
            return TAG_VERSION_PREDICATE.test(version);
        }
    }

    public static class AnyVersion
    extends DockerImageVersion {
        static final TagVersion LATEST_VERSION = new TagVersion("latest");

        AnyVersion() {
            super(null);
        }

        @Override
        public String getSeparator() {
            return LATEST_VERSION.getSeparator();
        }

        @Override
        public String getVersionDesc() {
            return LATEST_VERSION.getVersionDesc();
        }

        @Override
        public boolean support(String version) {
            return true;
        }
    }
}

