/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.docker.image.cache;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import io.github.oitstack.goblin.runtime.docker.image.DockerImageName;
import io.github.oitstack.goblin.runtime.docker.image.cache.IImageCache;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ImageCache
implements IImageCache {
    private Map<DockerImageName, ImageData> cache = new ConcurrentHashMap<DockerImageName, ImageData>();

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        return ImageCacheHolder.INSTANCE;
    }

    public ImageData refresh(DockerImageName dockerImageName, DockerClient dockerClient) {
        InspectImageResponse response = null;
        try {
            response = dockerClient.inspectImageCmd(dockerImageName.toIdentifyName()).exec();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        if (response != null) {
            ImageData imageData = ImageData.from(response);
            this.cache.put(dockerImageName, imageData);
            return imageData;
        }
        this.cache.remove(dockerImageName);
        return null;
    }

    public ImageData get(DockerImageName dockerImageName) {
        return this.cache.get(dockerImageName);
    }

    public static class ImageData {
        public Long time;

        static ImageData from(InspectImageResponse inspectImageResponse) {
            return ImageData.builder().time(ZonedDateTime.parse(inspectImageResponse.getCreated()).toEpochSecond()).build();
        }

        ImageData(Long time) {
            this.time = time;
        }

        public static ImageDataBuilder builder() {
            return new ImageDataBuilder();
        }

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageData)) {
                return false;
            }
            ImageData other = (ImageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            return result;
        }

        public String toString() {
            return "ImageCache.ImageData(time=" + this.getTime() + ")";
        }

        public static class ImageDataBuilder {
            private Long time;

            ImageDataBuilder() {
            }

            public ImageDataBuilder time(Long time) {
                this.time = time;
                return this;
            }

            public ImageData build() {
                return new ImageData(this.time);
            }

            public String toString() {
                return "ImageCache.ImageData.ImageDataBuilder(time=" + this.time + ")";
            }
        }
    }

    static class ImageCacheHolder {
        public static final ImageCache INSTANCE = new ImageCache();

        ImageCacheHolder() {
        }
    }
}

