/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.transfer.parser;

import io.github.oitstack.goblin.runtime.transfer.parser.JarResourceParser;
import io.github.oitstack.goblin.runtime.transfer.parser.NormalResourceParser;
import io.github.oitstack.goblin.runtime.transfer.parser.ResourceParser;
import java.util.ArrayList;
import java.util.List;

public class ResourceParserChain {
    private List<ResourceParser> parsers = new ArrayList<ResourceParser>();

    public static ResourceParserChain getInstance() {
        return ResourceParserChainHolder.chain;
    }

    private ResourceParserChain() {
        this.parsers.add(new JarResourceParser());
        this.parsers.add(new NormalResourceParser());
    }

    public String start(String resourcePath) {
        for (ResourceParser p : this.parsers) {
            if (!p.support(resourcePath)) continue;
            return p.getResource(resourcePath);
        }
        return null;
    }

    static class ResourceParserChainHolder {
        private static final ResourceParserChain chain = new ResourceParserChain();

        ResourceParserChainHolder() {
        }
    }
}

