/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarUtils {
    private static Logger log = LoggerFactory.getLogger(JarUtils.class);

    public static void extractFromJarToLocation(JarFile jarFile, JarEntry entry, String fromRoot, File toRoot) throws IOException {
        if (null == entry || entry.isDirectory()) {
            return;
        }
        String destinationName = entry.getName().replaceFirst(fromRoot, "");
        File newFile = JarUtils.initNewFile(destinationName, toRoot);
        try (InputStream is = jarFile.getInputStream(entry);){
            Files.copy(is, newFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            log.error("Failed to extract classpath resource " + entry.getName() + " from JAR file " + jarFile.getName(), (Throwable)e);
            throw e;
        }
    }

    private static File initNewFile(String destinationName, File toRoot) {
        File newFile = new File(toRoot, destinationName);
        Path parent = newFile.getAbsoluteFile().toPath().getParent();
        parent.toFile().mkdirs();
        newFile.deleteOnExit();
        return newFile;
    }
}

