/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.utils;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class PathUtils {
    private static final char SLASH = '/';
    private static final char DOUBLE_BACK_SLASH = '\\';
    private static final String DOUBLE_SLASH = "//";
    private static final String WIN_PATH_PATTERN = "\"^[a-zA-Z]:\\\\/.*\"";

    public static void delAllFromDir(Path dir) {
        try {
            if (dir == null) {
                return;
            }
            if (!Files.exists(dir, new LinkOption[0])) {
                return;
            }
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String createMinGWPath(String path) {
        String mingwPath = path.replace('\\', '/');
        int driveLetterIndex = mingwPath.matches(WIN_PATH_PATTERN) ? 0 : 1;
        char driveLetter = Character.toLowerCase(mingwPath.charAt(driveLetterIndex));
        String virtualPath = mingwPath.substring(driveLetterIndex + 1);
        mingwPath = DOUBLE_SLASH + driveLetter + virtualPath;
        mingwPath = mingwPath.replace(":", "");
        return mingwPath;
    }

    public static String formatResourceURIToFilePath(String resource) {
        try {
            return URLDecoder.decode(resource.replaceAll("\\+", "%2B"), Charsets.UTF_8.name()).replaceFirst("jar:", "").replaceFirst("file:", "").replaceAll("!.*", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

