/*
 * Decompiled with CFR 0.152.
 */
package io.github.oitstack.goblin.runtime.utils;

import java.security.AccessController;

public final class PropertyAndEnvUtils {
    private PropertyAndEnvUtils() {
    }

    public static String get(String key) {
        return PropertyAndEnvUtils.get(key, null);
    }

    public static String get(String key, String def) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = null;
        if ((value = PropertyAndEnvUtils.getFromEnv(key, value)) == null) {
            value = System.getProperty(key);
        }
        if (value == null) {
            return def;
        }
        return value;
    }

    private static String getFromEnv(String key, String value) {
        try {
            value = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> System.getProperty(key)) : System.getProperty(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static Object setProperty(String key, String value) {
        return System.getProperties().setProperty(key, value);
    }
}

