/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils;

import com.querydsl.codegen.utils.LocationAndKind;
import com.querydsl.codegen.utils.MemJavaFileObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public final class MemClassLoader
extends ClassLoader {
    private static final LocationAndKind CLASS_KEY = new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS);
    private static final LocationAndKind OTHER_KEY = new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.OTHER);
    private static final LocationAndKind SOURCE_KEY = new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.SOURCE);
    private final Map<LocationAndKind, Map<String, JavaFileObject>> memFileSystem;

    public MemClassLoader(ClassLoader parent, Map<LocationAndKind, Map<String, JavaFileObject>> ramFileSystem) {
        super(parent);
        this.memFileSystem = ramFileSystem;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        JavaFileObject jfo = this.memFileSystem.get(CLASS_KEY).get(name);
        if (jfo != null) {
            byte[] bytes = ((MemJavaFileObject)jfo).getByteArray();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }

    @Override
    protected URL findResource(String name) {
        URL retValue = super.findResource(name);
        if (retValue != null) {
            return retValue;
        }
        JavaFileObject jfo = this.getFileObject(name);
        if (jfo != null) {
            try {
                return jfo.toUri().toURL();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    private JavaFileObject getFileObject(String n) {
        LocationAndKind key;
        Object name;
        if (n.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            name = n.replace('.', '/') + JavaFileObject.Kind.CLASS.extension;
            key = CLASS_KEY;
        } else if (n.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            name = n.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension;
            key = SOURCE_KEY;
        } else {
            name = n;
            key = OTHER_KEY;
        }
        if (this.memFileSystem.containsKey(key)) {
            return this.memFileSystem.get(key).get(name);
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        JavaFileObject jfo = this.getFileObject(name);
        if (jfo != null) {
            byte[] bytes = ((MemJavaFileObject)jfo).getByteArray();
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> retValue = Collections.list(super.getResources(name));
        JavaFileObject jfo = this.getFileObject(name);
        if (jfo != null) {
            retValue.add(jfo.toUri().toURL());
        }
        return Collections.enumeration(retValue);
    }
}

