/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.NamingStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultNamingStrategyTest {
    private NamingStrategy namingStrategy = new DefaultNamingStrategy();
    private EntityType entityModel;

    @Before
    public void setUp() {
        this.entityModel = new EntityType((Type)Types.OBJECT);
        this.entityModel.getData().put("table", "OBJECT");
    }

    @Test
    public void getClassName() {
        Assert.assertEquals((Object)"UserData", (Object)this.namingStrategy.getClassName("user_data"));
        Assert.assertEquals((Object)"U", (Object)this.namingStrategy.getClassName("u"));
        Assert.assertEquals((Object)"Us", (Object)this.namingStrategy.getClassName("us"));
        Assert.assertEquals((Object)"U_", (Object)this.namingStrategy.getClassName("u_"));
        Assert.assertEquals((Object)"Us_", (Object)this.namingStrategy.getClassName("us_"));
        Assert.assertEquals((Object)"NewLine", (Object)this.namingStrategy.getClassName("new line"));
    }

    @Test
    public void getPropertyName() {
        Assert.assertEquals((Object)"a", (Object)this.namingStrategy.getPropertyName("a", this.entityModel));
        Assert.assertEquals((Object)"whileCol", (Object)this.namingStrategy.getPropertyName("while", this.entityModel));
        Assert.assertEquals((Object)"name", (Object)this.namingStrategy.getPropertyName("name", this.entityModel));
        Assert.assertEquals((Object)"userId", (Object)this.namingStrategy.getPropertyName("user_id", this.entityModel));
        Assert.assertEquals((Object)"accountEventId", (Object)this.namingStrategy.getPropertyName("accountEvent_id", this.entityModel));
        Assert.assertEquals((Object)"_123abc", (Object)this.namingStrategy.getPropertyName("123abc", this.entityModel));
        Assert.assertEquals((Object)"_123Abc", (Object)this.namingStrategy.getPropertyName("123 abc", this.entityModel));
        Assert.assertEquals((Object)"_123AbcDef", (Object)this.namingStrategy.getPropertyName("#123#abc#def", this.entityModel));
        Assert.assertEquals((Object)"newLine", (Object)this.namingStrategy.getPropertyName("new line", this.entityModel));
        Assert.assertEquals((Object)"classCol", (Object)this.namingStrategy.getPropertyName("class", this.entityModel));
        Assert.assertEquals((Object)"classCol", (Object)this.namingStrategy.getPropertyName("Class", this.entityModel));
    }

    @Test
    public void getPropertyName_with_dashes() {
        Assert.assertEquals((Object)"aFoobar", (Object)this.namingStrategy.getPropertyName("A-FOOBAR", this.entityModel));
        Assert.assertEquals((Object)"aFoobar", (Object)this.namingStrategy.getPropertyName("A_FOOBAR", this.entityModel));
    }

    @Test
    public void getPropertyName_for_column_with_spaces() {
        Assert.assertEquals((Object)"userId", (Object)this.namingStrategy.getPropertyName("user id", this.entityModel));
    }

    @Test
    public void getPropertyNameForInverseForeignKey() {
        Assert.assertEquals((Object)"_superiorFk", (Object)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_superior", this.entityModel));
    }

    @Test
    public void getPropertyNameForForeignKey() {
        Assert.assertEquals((Object)"superiorFk", (Object)this.namingStrategy.getPropertyNameForForeignKey("fk_superior", this.entityModel));
        Assert.assertEquals((Object)"superiorFk", (Object)this.namingStrategy.getPropertyNameForForeignKey("FK_SUPERIOR", this.entityModel));
        Assert.assertEquals((Object)"reffooBar", (Object)this.namingStrategy.getPropertyNameForForeignKey("REFFOO_BAR", this.entityModel));
        Assert.assertEquals((Object)"refFooBar", (Object)this.namingStrategy.getPropertyNameForForeignKey("REF_FOO_BAR", this.entityModel));
        Assert.assertEquals((Object)"refFooBar_", (Object)this.namingStrategy.getPropertyNameForForeignKey("REF_FOO_BAR_", this.entityModel));
    }

    @Test
    public void getPropertyNameForPrimaryKey() {
        Assert.assertEquals((Object)"superiorPk", (Object)this.namingStrategy.getPropertyNameForPrimaryKey("pk_superior", this.entityModel));
        Assert.assertEquals((Object)"superiorPk", (Object)this.namingStrategy.getPropertyNameForPrimaryKey("PK_SUPERIOR", this.entityModel));
    }

    @Test
    public void getPropertyNameForPrimaryKey_clash() {
        this.entityModel.addProperty(new Property(this.entityModel, "id", (Type)Types.STRING));
        Assert.assertEquals((Object)"idPk", (Object)this.namingStrategy.getPropertyNameForPrimaryKey("id", this.entityModel));
    }

    @Test
    public void getDefaultVariableName() {
        Assert.assertEquals((Object)"object", (Object)this.namingStrategy.getDefaultVariableName(this.entityModel));
    }

    @Test
    public void spaces() {
        Assert.assertEquals((Object)"a_b", (Object)this.namingStrategy.getPropertyName("a  b", this.entityModel));
    }

    @Test
    public void validName() {
        Assert.assertEquals((Object)"8FRecord", (Object)this.namingStrategy.normalizeColumnName("8FRecord"));
        Assert.assertEquals((Object)"_8FRecord", (Object)this.namingStrategy.getPropertyName("8FRecord", this.entityModel));
    }
}

