/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.OriginalNamingStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OriginalNamingStrategyTest {
    private NamingStrategy namingStrategy = new OriginalNamingStrategy();
    private EntityType entityModel;

    @Before
    public void setUp() {
        this.entityModel = new EntityType((Type)Types.OBJECT);
        this.entityModel.getData().put("table", "OBJECT");
    }

    @Test
    public void getClassName() {
        Assert.assertEquals((Object)"user_data", (Object)this.namingStrategy.getClassName("user_data"));
        Assert.assertEquals((Object)"u", (Object)this.namingStrategy.getClassName("u"));
        Assert.assertEquals((Object)"us", (Object)this.namingStrategy.getClassName("us"));
        Assert.assertEquals((Object)"u_", (Object)this.namingStrategy.getClassName("u_"));
        Assert.assertEquals((Object)"us_", (Object)this.namingStrategy.getClassName("us_"));
        Assert.assertEquals((Object)"new_line", (Object)this.namingStrategy.getClassName("new line"));
    }

    @Test
    public void getPropertyName() {
        Assert.assertEquals((Object)"while_col", (Object)this.namingStrategy.getPropertyName("while", this.entityModel));
        Assert.assertEquals((Object)"name", (Object)this.namingStrategy.getPropertyName("name", this.entityModel));
        Assert.assertEquals((Object)"user_id", (Object)this.namingStrategy.getPropertyName("user_id", this.entityModel));
        Assert.assertEquals((Object)"accountEvent_id", (Object)this.namingStrategy.getPropertyName("accountEvent_id", this.entityModel));
        Assert.assertEquals((Object)"_123abc", (Object)this.namingStrategy.getPropertyName("123abc", this.entityModel));
        Assert.assertEquals((Object)"_123_abc", (Object)this.namingStrategy.getPropertyName("123 abc", this.entityModel));
        Assert.assertEquals((Object)"_123_abc_def", (Object)this.namingStrategy.getPropertyName("#123#abc#def", this.entityModel));
        Assert.assertEquals((Object)"new_line", (Object)this.namingStrategy.getPropertyName("new line", this.entityModel));
    }

    @Test
    public void getPropertyName_with_dashes() {
        Assert.assertEquals((Object)"A_FOOBAR", (Object)this.namingStrategy.getPropertyName("A-FOOBAR", this.entityModel));
        Assert.assertEquals((Object)"A_FOOBAR", (Object)this.namingStrategy.getPropertyName("A_FOOBAR", this.entityModel));
    }

    @Test
    public void getPropertyNameForInverseForeignKey() {
        Assert.assertEquals((Object)"_fk_superior", (Object)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_superior", this.entityModel));
    }

    @Test
    public void getPropertyNameForForeignKey() {
        Assert.assertEquals((Object)"fk_superior", (Object)this.namingStrategy.getPropertyNameForForeignKey("fk_superior", this.entityModel));
        Assert.assertEquals((Object)"FK_SUPERIOR", (Object)this.namingStrategy.getPropertyNameForForeignKey("FK_SUPERIOR", this.entityModel));
    }

    @Test
    public void getDefaultVariableName() {
        Assert.assertEquals((Object)"OBJECT", (Object)this.namingStrategy.getDefaultVariableName(this.entityModel));
    }
}

