/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.utils.SimpleCompiler;
import com.querydsl.sql.AbstractJDBCTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.types.AbstractType;
import com.querydsl.sql.types.Type;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class MetaDataSerializerTest
extends AbstractJDBCTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws SQLException, ClassNotFoundException {
        super.setUp();
        this.statement.execute("drop table employee if exists");
        this.statement.execute("drop table survey if exists");
        this.statement.execute("drop table date_test if exists");
        this.statement.execute("drop table date_time_test if exists");
        this.statement.execute("drop table spaces if exists");
        this.statement.execute("create table survey (id int, name varchar(30), CONSTRAINT PK_survey PRIMARY KEY (id, name))");
        this.statement.execute("create table date_test (d date)");
        this.statement.execute("create table date_time_test (dt datetime)");
        this.statement.execute("create table spaces (\"spaces  \n 1\" date)");
        this.statement.execute("create table employee(\nid INT,\nfirstname VARCHAR(50),\nlastname VARCHAR(50),\nsalary DECIMAL(10, 2),\ndatefield DATE,\ntimefield TIME,\nsuperior_id int,\nsurvey_id int,\n\"123abc\" int,\nsurvey_name varchar(30),\nCONSTRAINT PK_employee PRIMARY KEY (id),\nCONSTRAINT FK_survey FOREIGN KEY (survey_id, survey_name) REFERENCES survey(id,name),\nCONSTRAINT FK_superior FOREIGN KEY (superior_id) REFERENCES employee(id))");
    }

    @Test
    public void normal_serialization() throws SQLException {
        String namePrefix = "Q";
        DefaultNamingStrategy namingStrategy = new DefaultNamingStrategy();
        MetaDataExporter exporter = new MetaDataExporter();
        exporter.setBeanSerializerClass(BeanSerializer.class);
        exporter.setNamePrefix(namePrefix);
        exporter.setPackageName("test");
        exporter.setTargetFolder(this.folder.getRoot());
        exporter.setNamingStrategy((NamingStrategy)namingStrategy);
        exporter.export(this.connection.getMetaData());
        this.compile(exporter);
        try {
            this.assertFileContainsInOrder("test/QSurvey.java", "import %s;".formatted(GeneratedAnnotationResolver.resolveDefault().getName()), "@Generated(\"com.querydsl.sql.codegen.MetaDataSerializer\")\npublic class QSurvey", "    public QSurvey(String variable, String schema) {\n        super(Survey.class, forVariable(variable), schema, \"SURVEY\");\n        addMetadata();\n    }");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Test
    public void customized_serialization() throws SQLException {
        String namePrefix = "Q";
        Configuration conf = new Configuration(SQLTemplates.DEFAULT);
        conf.register("EMPLOYEE", "ID", (Type)new AbstractType<CustomNumber>(this, 0){

            public Class<CustomNumber> getReturnedClass() {
                return CustomNumber.class;
            }

            public CustomNumber getValue(ResultSet rs, int startIndex) throws SQLException {
                throw new UnsupportedOperationException();
            }

            public void setValue(PreparedStatement st, int startIndex, CustomNumber value) throws SQLException {
                throw new UnsupportedOperationException();
            }
        });
        DefaultNamingStrategy namingStrategy = new DefaultNamingStrategy();
        MetaDataExporter exporter = new MetaDataExporter();
        exporter.setBeanSerializerClass(BeanSerializer.class);
        exporter.setNamePrefix(namePrefix);
        exporter.setPackageName("test");
        exporter.setTargetFolder(this.folder.getRoot());
        exporter.setNamingStrategy((NamingStrategy)namingStrategy);
        exporter.setConfiguration(conf);
        exporter.setGeneratedAnnotationClass("com.querydsl.core.annotations.Generated");
        exporter.export(this.connection.getMetaData());
        this.compile(exporter);
        try {
            this.assertFileContainsInOrder("test/QSurvey.java", "import com.querydsl.core.annotations.Generated;", "@Generated(\"com.querydsl.sql.codegen.MetaDataSerializer\")\npublic class QSurvey", "    public QSurvey(String variable, String schema) {\n        super(Survey.class, forVariable(variable), schema, \"SURVEY\");\n        addMetadata();\n    }");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void compile(MetaDataExporter exporter) {
        SimpleCompiler compiler = new SimpleCompiler();
        Set classes = exporter.getClasses();
        int compilationResult = compiler.run(null, null, null, classes.toArray(new String[0]));
        if (compilationResult == 0) {
            System.out.println("Compilation is successful");
        } else {
            Assertions.fail((String)"Compilation Failed");
        }
    }

    private void assertFileContainsInOrder(String path, String ... methods) throws IOException {
        String content = new String(Files.readAllBytes(this.folder.getRoot().toPath().resolve(path)), StandardCharsets.UTF_8);
        Assertions.assertThat((String)content).containsIgnoringWhitespaces((CharSequence[])methods);
    }

    public static class CustomNumber {
    }
}

