/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen.support;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.support.RenameMapping;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RenameMappingTest {
    private RenameMapping mapping = new RenameMapping();
    private Configuration configuration = new Configuration(SQLTemplates.DEFAULT);

    @Test
    public void schemaToSchema() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setToSchema("DEF");
        this.mapping.apply(this.configuration);
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("ABC", "TABLE"))).isEqualTo((Object)new SchemaAndTable("DEF", "TABLE"));
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("ABCD", "TABLE"))).isEqualTo((Object)new SchemaAndTable("ABCD", "TABLE"));
    }

    @Test
    public void tableToTable() {
        this.mapping.setFromTable("TABLE1");
        this.mapping.setToTable("TABLE2");
        this.mapping.apply(this.configuration);
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE1"))).isEqualTo((Object)new SchemaAndTable("DEF", "TABLE2"));
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE3"))).isEqualTo((Object)new SchemaAndTable("DEF", "TABLE3"));
    }

    @Test
    public void schemaTableToTable() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setFromTable("TABLE1");
        this.mapping.setToTable("TABLE2");
        this.mapping.apply(this.configuration);
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("ABC", "TABLE1"))).isEqualTo((Object)new SchemaAndTable("ABC", "TABLE2"));
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE1"))).isEqualTo((Object)new SchemaAndTable("DEF", "TABLE1"));
    }

    @Test
    public void schemaTableToSchemaTable() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setFromTable("TABLE1");
        this.mapping.setToSchema("ABC");
        this.mapping.setToTable("TABLE2");
        this.mapping.apply(this.configuration);
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("ABC", "TABLE1"))).isEqualTo((Object)new SchemaAndTable("ABC", "TABLE2"));
        Assertions.assertThat((Object)this.configuration.getOverride(new SchemaAndTable("DEF", "TABLE1"))).isEqualTo((Object)new SchemaAndTable("DEF", "TABLE1"));
    }

    @Test
    public void schemaTableColumnToColumn() {
        this.mapping.setFromSchema("ABC");
        this.mapping.setFromTable("TABLE1");
        this.mapping.setFromColumn("COLUMN1");
        this.mapping.setToColumn("COLUMN2");
        this.mapping.apply(this.configuration);
        Assertions.assertThat((String)this.configuration.getColumnOverride(new SchemaAndTable("ABC", "TABLE1"), "COLUMN1")).isEqualTo("COLUMN2");
        Assertions.assertThat((String)this.configuration.getColumnOverride(new SchemaAndTable("DEF", "TABLE1"), "COLUMN1")).isEqualTo("COLUMN1");
    }

    @Test
    public void tableColumnToColumn() {
        this.mapping.setFromTable("TABLE1");
        this.mapping.setFromColumn("COLUMN1");
        this.mapping.setToColumn("COLUMN2");
        this.mapping.apply(this.configuration);
        Assertions.assertThat((String)this.configuration.getColumnOverride(new SchemaAndTable("ABC", "TABLE1"), "COLUMN1")).isEqualTo("COLUMN2");
        Assertions.assertThat((String)this.configuration.getColumnOverride(new SchemaAndTable("ABC", "TABLE2"), "COLUMN1")).isEqualTo("COLUMN1");
    }
}

