/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.JavaWriter;
import com.querydsl.codegen.utils.ScalaWriter;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.sql.ColumnImpl;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLTemplatesRegistry;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.KeyDataFactory;
import com.querydsl.sql.codegen.MetadataExporterConfig;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.SQLCodegenModule;
import com.querydsl.sql.codegen.support.CustomType;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import com.querydsl.sql.codegen.support.InverseForeignKeyData;
import com.querydsl.sql.codegen.support.NotNullImpl;
import com.querydsl.sql.codegen.support.NumericMapping;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import com.querydsl.sql.codegen.support.RenameMapping;
import com.querydsl.sql.codegen.support.SizeImpl;
import com.querydsl.sql.codegen.support.TypeMapping;
import com.querydsl.sql.types.Type;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class MetaDataExporter {
    private static final Logger logger = Logger.getLogger(MetaDataExporter.class.getName());
    private final SQLTemplatesRegistry sqlTemplatesRegistry = new SQLTemplatesRegistry();
    private final SQLCodegenModule module = new SQLCodegenModule();
    private final Set<String> classes = new HashSet<String>();
    @Nullable
    private String beanPackageName;
    private final Map<EntityType, com.querydsl.codegen.utils.model.Type> entityToWrapped = new HashMap<EntityType, com.querydsl.codegen.utils.model.Type>();
    private Serializer serializer;
    private QueryTypeFactory queryTypeFactory;
    private NamingStrategy namingStrategy;
    private Configuration configuration;
    private KeyDataFactory keyDataFactory;
    private final MetadataExporterConfig config;
    private Serializer beanSerializer;
    private TypeMappings typeMappings;

    public MetaDataExporter(MetadataExporterConfig config) {
        this.config = config;
    }

    protected EntityType createEntityType(SchemaAndTable schemaAndTable, String className) {
        EntityType classModel;
        if (this.beanSerializer == null) {
            String packageName = this.normalizePackage(this.module.getPackageName(), schemaAndTable);
            String simpleName = this.module.getPrefix() + className + this.module.getSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, packageName + "." + simpleName, packageName, simpleName, false, false, new com.querydsl.codegen.utils.model.Type[0]);
            classModel = new EntityType((com.querydsl.codegen.utils.model.Type)classTypeModel, (Function)this.module.get(Function.class, "variableNameFunction"));
            this.typeMappings.register((com.querydsl.codegen.utils.model.Type)classModel, (com.querydsl.codegen.utils.model.Type)classModel);
        } else {
            String beanPackage = this.normalizePackage(this.beanPackageName, schemaAndTable);
            String simpleName = this.module.getBeanPrefix() + className + this.module.getBeanSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, beanPackage + "." + simpleName, beanPackage, simpleName, false, false, new com.querydsl.codegen.utils.model.Type[0]);
            classModel = new EntityType((com.querydsl.codegen.utils.model.Type)classTypeModel, (Function)this.module.get(Function.class, "variableNameFunction"));
            com.querydsl.codegen.utils.model.Type mappedType = this.queryTypeFactory.create((com.querydsl.codegen.utils.model.Type)classModel);
            this.entityToWrapped.put(classModel, mappedType);
            this.typeMappings.register((com.querydsl.codegen.utils.model.Type)classModel, mappedType);
        }
        classModel.getData().put("schema", schemaAndTable.getSchema());
        classModel.getData().put("table", schemaAndTable.getTable());
        return classModel;
    }

    private String normalizePackage(String packageName, SchemaAndTable schemaAndTable) {
        String rval = packageName;
        if (this.config.isSchemaToPackage()) {
            rval = this.namingStrategy.getPackage(rval, schemaAndTable);
        }
        return rval;
    }

    protected Property createProperty(EntityType classModel, String normalizedColumnName, String propertyName, com.querydsl.codegen.utils.model.Type typeModel) {
        return new Property(classModel, propertyName, propertyName, typeModel, Collections.emptyList(), false);
    }

    public void export(DatabaseMetaData md) throws SQLException {
        ArrayList<String> types;
        this.configuration = (Configuration)this.module.get(Configuration.class);
        this.configureModule();
        if (this.config.getNamingStrategyClass() != null) {
            try {
                this.namingStrategy = this.config.getNamingStrategyClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.namingStrategy = new DefaultNamingStrategy();
        }
        this.module.bind(NamingStrategy.class, this.namingStrategy);
        this.beanPackageName = this.config.getBeanPackageName() == null ? this.module.getPackageName() : this.config.getBeanPackageName();
        this.module.bind("beanPackageName", this.beanPackageName);
        this.module.loadExtensions();
        this.classes.clear();
        this.typeMappings = (TypeMappings)this.module.get(TypeMappings.class);
        this.queryTypeFactory = (QueryTypeFactory)this.module.get(QueryTypeFactory.class);
        this.serializer = (Serializer)this.module.get(Serializer.class);
        this.beanSerializer = (Serializer)this.module.get(Serializer.class, "beanSerializer");
        this.namingStrategy = (NamingStrategy)this.module.get(NamingStrategy.class);
        SQLTemplates templates = this.sqlTemplatesRegistry.getTemplates(md);
        if (templates != null) {
            this.configuration.setTemplates(templates);
        } else {
            logger.info("Found no specific dialect for " + md.getDatabaseProductName());
        }
        this.keyDataFactory = this.beanSerializer == null ? new KeyDataFactory(this.namingStrategy, this.module.getPackageName(), this.module.getPrefix(), this.module.getSuffix(), this.config.isSchemaToPackage()) : new KeyDataFactory(this.namingStrategy, this.beanPackageName, this.module.getBeanPrefix(), this.module.getBeanSuffix(), this.config.isSchemaToPackage());
        String[] typesArray = null;
        if (this.config.getTableTypesToExport() != null && !this.config.getTableTypesToExport().isEmpty()) {
            types = new ArrayList<String>();
            for (String tableType : this.config.getTableTypesToExport().split(",")) {
                types.add(tableType.trim());
            }
            typesArray = types.toArray(new String[0]);
        } else if (!this.config.isExportAll()) {
            types = new ArrayList(2);
            if (this.config.isExportTables()) {
                types.add("TABLE");
            }
            if (this.config.isExportViews()) {
                types.add("VIEW");
            }
            typesArray = types.toArray(new String[0]);
        }
        List<String> catalogs = this.patternAsList(this.config.getCatalogPattern());
        List<String> schemas = this.patternAsList(this.config.getSchemaPattern());
        List<String> tables = this.patternAsList(this.config.getTableNamePattern());
        for (String catalog : catalogs) {
            catalog = this.trimIfNonNull(catalog);
            for (String schema : schemas) {
                schema = this.trimIfNonNull(schema);
                for (String table : tables) {
                    table = this.trimIfNonNull(table);
                    this.handleTables(md, catalog, schema, table, typesArray);
                }
            }
        }
    }

    private void configureModule() {
        if (this.config.getNamePrefix() != null) {
            this.module.bind("prefix", this.config.getNamePrefix());
        }
        if (this.config.getNameSuffix() != null) {
            this.module.bind("suffix", this.config.getNameSuffix());
        }
        if (this.config.getBeanPrefix() != null) {
            this.module.bind("beanPrefix", this.config.getBeanPrefix());
        }
        if (this.config.getBeanSuffix() != null) {
            this.module.bind("beanSuffix", this.config.getBeanSuffix());
        }
        this.module.bind("packageName", this.config.getPackageName());
        this.module.bind("innerClassesForKeys", this.config.isInnerClassesForKeys());
        this.module.bind(NamingStrategy.class, this.namingStrategy);
        this.module.bind("schemaToPackage", this.config.isSchemaToPackage());
        if (this.config.getImports() != null && !this.config.getImports().isEmpty()) {
            this.module.bind("imports", new HashSet<String>(this.config.getImports()));
        }
        this.module.bindInstance("generatedAnnotationClass", GeneratedAnnotationResolver.resolve((String)this.config.getGeneratedAnnotationClass()));
        if (this.config.isExportBeans()) {
            BeanSerializer serializer;
            if (this.config.getBeanSerializerClass() == null) {
                serializer = new BeanSerializer();
            } else {
                try {
                    serializer = this.config.getBeanSerializerClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }
            if (serializer instanceof BeanSerializer) {
                BeanSerializer beanSerializer = serializer;
                if (this.config.getBeanInterfaces() != null) {
                    for (String iface : this.config.getBeanInterfaces()) {
                        int sepIndex = iface.lastIndexOf(46);
                        if (sepIndex < 0) {
                            beanSerializer.addInterface((com.querydsl.codegen.utils.model.Type)new SimpleType(iface));
                            continue;
                        }
                        String packageName = iface.substring(0, sepIndex);
                        String simpleName = iface.substring(sepIndex + 1);
                        beanSerializer.addInterface((com.querydsl.codegen.utils.model.Type)new SimpleType(iface, packageName, simpleName, new com.querydsl.codegen.utils.model.Type[0]));
                    }
                }
                beanSerializer.setAddFullConstructor(this.config.isBeanAddFullConstructor());
                beanSerializer.setAddToString(this.config.isBeanAddToString());
                beanSerializer.setPrintSupertype(this.config.isBeanPrintSupertype());
            }
            this.module.bind("beanSerializer", serializer);
        }
        if (this.config.getCustomTypes() != null) {
            for (CustomType customType : this.config.getCustomTypes()) {
                try {
                    this.configuration.register((Type)Class.forName(customType.getClassName()).newInstance());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.config.getTypeMappings() != null) {
            for (TypeMapping typeMapping : this.config.getTypeMappings()) {
                typeMapping.apply(this.configuration);
            }
        }
        if (this.config.getNumericMappings() != null) {
            for (NumericMapping numericMapping : this.config.getNumericMappings()) {
                numericMapping.apply(this.configuration);
            }
        }
        if (this.config.getRenameMappings() != null) {
            for (RenameMapping renameMapping : this.config.getRenameMappings()) {
                renameMapping.apply(this.configuration);
            }
        }
        if (this.config.getColumnComparatorClass() != null) {
            this.module.bind("columnComparator", this.config.getColumnComparatorClass().asSubclass(Comparator.class));
        }
        if (this.config.getSerializerClass() != null) {
            this.module.bind(Serializer.class, this.config.getSerializerClass());
        }
    }

    private String trimIfNonNull(String input) {
        return input != null ? input.trim() : null;
    }

    private List<String> patternAsList(@Nullable String input) {
        if (input != null && input.contains(",")) {
            return Arrays.asList(input.split(","));
        }
        return Collections.singletonList(input);
    }

    private void handleTables(DatabaseMetaData md, String catalogPattern, String schemaPattern, String tablePattern, String[] types) throws SQLException {
        try (ResultSet tables = md.getTables(catalogPattern, schemaPattern, tablePattern, types);){
            while (tables.next()) {
                this.handleTable(md, tables);
            }
        }
    }

    Set<String> getClasses() {
        return this.classes;
    }

    private void handleColumn(EntityType classModel, String tableName, ResultSet columns) throws SQLException {
        String columnName = this.normalize(columns.getString("COLUMN_NAME"));
        String normalizedColumnName = this.namingStrategy.normalizeColumnName(columnName);
        int columnType = columns.getInt("DATA_TYPE");
        String typeName = columns.getString("TYPE_NAME");
        Number columnSize = (Number)columns.getObject("COLUMN_SIZE");
        Number columnDigits = (Number)columns.getObject("DECIMAL_DIGITS");
        int columnIndex = columns.getInt("ORDINAL_POSITION");
        int nullable = columns.getInt("NULLABLE");
        String columnDefaultValue = columns.getString("COLUMN_DEF");
        String propertyName = this.namingStrategy.getPropertyName(normalizedColumnName, classModel);
        Class<Object> clazz = this.configuration.getJavaType(columnType, typeName, columnSize != null ? columnSize.intValue() : 0, columnDigits != null ? columnDigits.intValue() : 0, tableName, columnName);
        if (clazz == null) {
            clazz = Object.class;
        }
        TypeCategory fieldType = TypeCategory.get((String)clazz.getName());
        if (Number.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.NUMERIC;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.ENUM;
        }
        ClassType typeModel = new ClassType(fieldType, clazz, new com.querydsl.codegen.utils.model.Type[0]);
        Property property = this.createProperty(classModel, normalizedColumnName, propertyName, (com.querydsl.codegen.utils.model.Type)typeModel);
        ColumnMetadata column = ColumnMetadata.named((String)normalizedColumnName).ofType(columnType).withIndex(columnIndex);
        if (nullable == 0) {
            column = column.notNull();
        }
        if (columnSize != null) {
            column = column.withSize(columnSize.intValue());
        }
        if (columnDigits != null) {
            column = column.withDigits(columnDigits.intValue());
        }
        property.getData().put("COLUMN", column);
        if (this.config.isColumnAnnotations()) {
            property.addAnnotation((Annotation)new ColumnImpl(normalizedColumnName));
        }
        if (this.config.isValidationAnnotations()) {
            int size;
            if (nullable == 0 && columnDefaultValue == null) {
                property.addAnnotation((Annotation)((Object)new NotNullImpl()));
            }
            if ((size = columns.getInt("COLUMN_SIZE")) > 0 && clazz.equals(String.class)) {
                property.addAnnotation((Annotation)((Object)new SizeImpl(0, size)));
            }
        }
        classModel.addProperty(property);
    }

    private void handleTable(DatabaseMetaData md, ResultSet tables) throws SQLException {
        Map<String, PrimaryKeyData> primaryKeyData;
        String normalizedTableName;
        String catalog = tables.getString("TABLE_CAT");
        String schema = tables.getString("TABLE_SCHEM");
        String schemaName = this.normalize(tables.getString("TABLE_SCHEM"));
        String tableName = this.normalize(tables.getString("TABLE_NAME"));
        String normalizedSchemaName = this.namingStrategy.normalizeSchemaName(schemaName);
        SchemaAndTable schemaAndTable = new SchemaAndTable(normalizedSchemaName, normalizedTableName = this.namingStrategy.normalizeTableName(tableName));
        if (!this.namingStrategy.shouldGenerateClass(schemaAndTable)) {
            return;
        }
        String className = this.namingStrategy.getClassName(schemaAndTable);
        EntityType classModel = this.createEntityType(schemaAndTable, className);
        if (this.config.isExportPrimaryKeys() && !(primaryKeyData = this.keyDataFactory.getPrimaryKeys(md, catalog, schema, tableName)).isEmpty()) {
            classModel.getData().put(PrimaryKeyData.class, primaryKeyData.values());
        }
        if (this.config.isExportForeignKeys()) {
            Map<String, InverseForeignKeyData> inverseForeignKeyData;
            Map<String, ForeignKeyData> foreignKeyData;
            if (this.config.isExportDirectForeignKeys() && !(foreignKeyData = this.keyDataFactory.getImportedKeys(md, catalog, schema, tableName)).isEmpty()) {
                LinkedHashSet<ForeignKeyData> foreignKeysToGenerate = new LinkedHashSet<ForeignKeyData>();
                for (ForeignKeyData fkd : foreignKeyData.values()) {
                    if (!this.namingStrategy.shouldGenerateForeignKey(schemaAndTable, fkd)) continue;
                    foreignKeysToGenerate.add(fkd);
                }
                if (!foreignKeysToGenerate.isEmpty()) {
                    classModel.getData().put(ForeignKeyData.class, foreignKeysToGenerate);
                }
            }
            if (this.config.isExportInverseForeignKeys() && !(inverseForeignKeyData = this.keyDataFactory.getExportedKeys(md, catalog, schema, tableName)).isEmpty()) {
                classModel.getData().put(InverseForeignKeyData.class, inverseForeignKeyData.values());
            }
        }
        try (ResultSet columns = md.getColumns(catalog, schema, tableName.replace("/", "//"), null);){
            while (columns.next()) {
                this.handleColumn(classModel, tableName, columns);
            }
        }
        this.serialize(classModel, schemaAndTable);
        logger.info("Exported " + tableName + " successfully");
    }

    private String normalize(String str) {
        if (this.config.isLowerCase() && str != null) {
            return str.toLowerCase();
        }
        return str;
    }

    private void serialize(EntityType type, SchemaAndTable schemaAndTable) {
        try {
            String fileSuffix;
            String string = fileSuffix = this.config.isCreateScalaSources() ? ".scala" : ".java";
            if (this.beanSerializer != null) {
                String packageName = this.normalizePackage(this.beanPackageName, schemaAndTable);
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.beanSerializer, new File(this.config.getBeansTargetFolder() != null ? this.config.getBeansTargetFolder() : this.config.getTargetFolder(), path), type);
                String otherPath = this.entityToWrapped.get(type).getFullName().replace('.', '/') + fileSuffix;
                this.write(this.serializer, new File(this.config.getTargetFolder(), otherPath), type);
            } else {
                String packageName = this.normalizePackage(this.module.getPackageName(), schemaAndTable);
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.serializer, new File(this.config.getTargetFolder(), path), type);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void write(Serializer serializer, File targetFile, EntityType type) throws IOException {
        if (!this.classes.add(targetFile.getPath())) {
            throw new IllegalStateException("Attempted to write multiple times to " + targetFile.getPath() + ", please check your configuration");
        }
        StringWriter w = new StringWriter();
        ScalaWriter writer = this.config.isCreateScalaSources() ? new ScalaWriter((Appendable)w) : new JavaWriter((Appendable)w);
        serializer.serialize(type, SimpleSerializerConfig.DEFAULT, (CodeWriter)writer);
        boolean generate = true;
        byte[] bytes = w.toString().getBytes(this.config.getSourceEncoding());
        if (targetFile.exists() && targetFile.length() == (long)bytes.length) {
            String str = new String(Files.readAllBytes(targetFile.toPath()), this.config.getSourceEncoding());
            if (str.equals(w.toString())) {
                generate = false;
            }
        } else {
            targetFile.getParentFile().mkdirs();
        }
        if (generate) {
            Files.write(targetFile.toPath(), bytes, new OpenOption[0]);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.module.bind(Configuration.class, configuration);
    }

    public void setTypeMappings(TypeMappings typeMappings) {
        this.module.bind(TypeMappings.class, typeMappings);
    }
}

