/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.OriginalNamingStrategy;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OriginalNamingStrategyTest {
    private NamingStrategy namingStrategy = new OriginalNamingStrategy();
    private EntityType entityModel;

    @Before
    public void setUp() {
        this.entityModel = new EntityType((Type)Types.OBJECT);
        this.entityModel.getData().put("table", "OBJECT");
    }

    @Test
    public void getClassName() {
        Assertions.assertThat((String)this.namingStrategy.getClassName("user_data")).isEqualTo("user_data");
        Assertions.assertThat((String)this.namingStrategy.getClassName("u")).isEqualTo("u");
        Assertions.assertThat((String)this.namingStrategy.getClassName("us")).isEqualTo("us");
        Assertions.assertThat((String)this.namingStrategy.getClassName("u_")).isEqualTo("u_");
        Assertions.assertThat((String)this.namingStrategy.getClassName("us_")).isEqualTo("us_");
        Assertions.assertThat((String)this.namingStrategy.getClassName("new line")).isEqualTo("new_line");
    }

    @Test
    public void getPropertyName() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("while", this.entityModel)).isEqualTo("while_col");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("name", this.entityModel)).isEqualTo("name");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("user_id", this.entityModel)).isEqualTo("user_id");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("accountEvent_id", this.entityModel)).isEqualTo("accountEvent_id");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("123abc", this.entityModel)).isEqualTo("_123abc");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("123 abc", this.entityModel)).isEqualTo("_123_abc");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("#123#abc#def", this.entityModel)).isEqualTo("_123_abc_def");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("new line", this.entityModel)).isEqualTo("new_line");
    }

    @Test
    public void getPropertyName_with_dashes() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("A-FOOBAR", this.entityModel)).isEqualTo("A_FOOBAR");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("A_FOOBAR", this.entityModel)).isEqualTo("A_FOOBAR");
    }

    @Test
    public void getPropertyNameForInverseForeignKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_superior", this.entityModel)).isEqualTo("_fk_superior");
    }

    @Test
    public void getPropertyNameForForeignKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("fk_superior", this.entityModel)).isEqualTo("fk_superior");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("FK_SUPERIOR", this.entityModel)).isEqualTo("FK_SUPERIOR");
    }

    @Test
    public void getDefaultVariableName() {
        Assertions.assertThat((String)this.namingStrategy.getDefaultVariableName(this.entityModel)).isEqualTo("OBJECT");
    }
}

