/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen.ant;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.Serializer;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.MetadataExporterConfig;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.CustomType;
import com.querydsl.sql.codegen.support.NumericMapping;
import com.querydsl.sql.codegen.support.RenameMapping;
import com.querydsl.sql.codegen.support.TypeMapping;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntMetaDataExporter
extends Task
implements MetadataExporterConfig {
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String namePrefix;
    private String nameSuffix;
    private String beanPrefix;
    private String beanSuffix;
    private String packageName;
    private String beanPackageName;
    private String schemaPattern;
    private String catalogPattern;
    private String tableNamePattern;
    private String targetFolder;
    private String beansTargetFolder;
    private String namingStrategyClass = DefaultNamingStrategy.class.getName();
    private String beanSerializerClass = BeanSerializer.class.getName();
    private String serializerClass;
    private boolean exportBeans;
    private String[] beanInterfaces;
    private boolean beanAddToString;
    private boolean beanAddFullConstructor;
    private boolean beanPrintSupertype;
    private boolean innerClassesForKeys;
    private boolean validationAnnotations;
    private boolean columnAnnotations;
    private List<CustomType> customTypes = new ArrayList<CustomType>();
    private boolean createScalaSources;
    private boolean schemaToPackage;
    private boolean lowerCase;
    private boolean exportTables = true;
    private boolean exportViews = true;
    private boolean exportAll;
    private boolean exportPrimaryKeys = true;
    private boolean exportForeignKeys = true;
    private boolean exportDirectForeignKeys = true;
    private boolean exportInverseForeignKeys = true;
    private String columnComparatorClass;
    private String tableTypesToExport;
    private String[] imports;
    private String sourceEncoding;
    private List<TypeMapping> typeMappings = new ArrayList<TypeMapping>();
    private List<NumericMapping> numericMappings = new ArrayList<NumericMapping>();
    private List<RenameMapping> renameMappings = new ArrayList<RenameMapping>();

    public void execute() {
        if (this.targetFolder == null) {
            throw new BuildException("targetFolder is a mandatory property");
        }
        Connection dbConn = null;
        try {
            Class.forName(this.jdbcDriver).newInstance();
            dbConn = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            MetaDataExporter exporter = new MetaDataExporter(this);
            exporter.export(dbConn.getMetaData());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException | SQLException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException e2) {
                    throw new BuildException((Throwable)e2);
                }
            }
        }
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    @Override
    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    @Override
    public String getBeanPrefix() {
        return this.beanPrefix;
    }

    public void setBeanPrefix(String beanPrefix) {
        this.beanPrefix = beanPrefix;
    }

    @Override
    public String getBeanSuffix() {
        return this.beanSuffix;
    }

    public void setBeanSuffix(String beanSuffix) {
        this.beanSuffix = beanSuffix;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getBeanPackageName() {
        return this.beanPackageName;
    }

    public void setBeanPackageName(String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    @Override
    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    @Override
    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    @Override
    public File getTargetFolder() {
        return new File(this.targetFolder);
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    @Override
    public Class<? extends NamingStrategy> getNamingStrategyClass() {
        if (this.namingStrategyClass == null) {
            return null;
        }
        try {
            return Class.forName(this.namingStrategyClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setNamingStrategyClass(String namingStrategyClass) {
        this.namingStrategyClass = namingStrategyClass;
    }

    public Class<? extends BeanSerializer> getBeanSerializerClass() {
        if (this.exportBeans && this.beanSerializerClass != null) {
            try {
                return Class.forName(this.beanSerializerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setBeanSerializerClass(String beanSerializerClass) {
        this.beanSerializerClass = beanSerializerClass;
    }

    @Override
    public Class<? extends Serializer> getSerializerClass() {
        if (this.serializerClass == null) {
            return null;
        }
        try {
            return Class.forName(this.serializerClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    @Override
    public boolean isExportBeans() {
        return this.exportBeans;
    }

    public void setExportBeans(boolean exportBeans) {
        this.exportBeans = exportBeans;
    }

    @Override
    public String[] getBeanInterfaces() {
        return this.beanInterfaces;
    }

    public void setBeanInterfaces(String[] beanInterfaces) {
        this.beanInterfaces = beanInterfaces;
    }

    @Override
    public boolean isBeanAddToString() {
        return this.beanAddToString;
    }

    public void setBeanAddToString(boolean beanAddToString) {
        this.beanAddToString = beanAddToString;
    }

    @Override
    public boolean isBeanAddFullConstructor() {
        return this.beanAddFullConstructor;
    }

    public void setBeanAddFullConstructor(boolean beanAddFullConstructor) {
        this.beanAddFullConstructor = beanAddFullConstructor;
    }

    @Override
    public boolean isBeanPrintSupertype() {
        return this.beanPrintSupertype;
    }

    public void setBeanPrintSupertype(boolean beanPrintSupertype) {
        this.beanPrintSupertype = beanPrintSupertype;
    }

    @Override
    public boolean isInnerClassesForKeys() {
        return this.innerClassesForKeys;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.innerClassesForKeys = innerClassesForKeys;
    }

    @Override
    public boolean isValidationAnnotations() {
        return this.validationAnnotations;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    @Override
    public boolean isColumnAnnotations() {
        return this.columnAnnotations;
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void addCustomType(CustomType customType) {
        this.customTypes.add(customType);
    }

    @Override
    public List<CustomType> getCustomTypes() {
        return this.customTypes;
    }

    public void setCustomTypes(String[] strings) {
        this.customTypes.clear();
        for (String string : strings) {
            CustomType customType = new CustomType();
            customType.setClassName(string);
            this.customTypes.add(customType);
        }
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    @Override
    public boolean isSchemaToPackage() {
        return this.schemaToPackage;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
    }

    @Override
    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    @Override
    public boolean isExportTables() {
        return this.exportTables;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    @Override
    public boolean isExportViews() {
        return this.exportViews;
    }

    public void setExportViews(boolean exportViews) {
        this.exportViews = exportViews;
    }

    @Override
    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    @Override
    public boolean isExportPrimaryKeys() {
        return this.exportPrimaryKeys;
    }

    public void setExportPrimaryKeys(boolean exportPrimaryKeys) {
        this.exportPrimaryKeys = exportPrimaryKeys;
    }

    @Override
    public boolean isExportForeignKeys() {
        return this.exportForeignKeys;
    }

    @Override
    public boolean isExportDirectForeignKeys() {
        return this.exportDirectForeignKeys;
    }

    public void setExportDirectForeignKeys(boolean exportDirectForeignKeys) {
        this.exportDirectForeignKeys = exportDirectForeignKeys;
    }

    @Override
    public boolean isExportInverseForeignKeys() {
        return this.exportInverseForeignKeys;
    }

    public void setExportInverseForeignKeys(boolean exportInverseForeignKeys) {
        this.exportInverseForeignKeys = exportInverseForeignKeys;
    }

    public void setExportForeignKeys(boolean exportForeignKeys) {
        this.exportForeignKeys = exportForeignKeys;
    }

    @Override
    public Class<? extends Comparator<Property>> getColumnComparatorClass() {
        if (this.columnComparatorClass == null) {
            return null;
        }
        try {
            return Class.forName(this.columnComparatorClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setColumnComparatorClass(String columnComparatorClass) {
        this.columnComparatorClass = columnComparatorClass;
    }

    @Override
    public String getTableTypesToExport() {
        return this.tableTypesToExport;
    }

    public void setTableTypesToExport(String tableTypesToExport) {
        this.tableTypesToExport = tableTypesToExport;
    }

    @Override
    public List<String> getImports() {
        if (this.imports == null) {
            return null;
        }
        return Arrays.asList(this.imports);
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }

    @Override
    public Charset getSourceEncoding() {
        if (this.sourceEncoding != null) {
            return Charset.forName(this.sourceEncoding);
        }
        return StandardCharsets.UTF_8;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    @Override
    public File getBeansTargetFolder() {
        if (this.beansTargetFolder != null) {
            return new File(this.beansTargetFolder);
        }
        return null;
    }

    public void setBeansTargetFolder(String beansTargetFolder) {
        this.beansTargetFolder = beansTargetFolder;
    }

    public void addTypeMapping(TypeMapping mapping) {
        this.typeMappings.add(mapping);
    }

    public void addNumericMapping(NumericMapping mapping) {
        this.numericMappings.add(mapping);
    }

    public void addRenameMapping(RenameMapping mapping) {
        this.renameMappings.add(mapping);
    }

    @Override
    public boolean isCreateScalaSources() {
        return this.createScalaSources;
    }

    @Override
    public String getCatalogPattern() {
        return this.catalogPattern;
    }

    public void setCatalogPattern(String catalogPattern) {
        this.catalogPattern = catalogPattern;
    }

    @Override
    public String getGeneratedAnnotationClass() {
        return null;
    }

    @Override
    public List<TypeMapping> getTypeMappings() {
        return this.typeMappings;
    }

    @Override
    public List<NumericMapping> getNumericMappings() {
        return this.numericMappings;
    }

    @Override
    public List<RenameMapping> getRenameMappings() {
        return this.renameMappings;
    }
}

