/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.sql.AbstractJDBCTest;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.KeyDataFactory;
import com.querydsl.sql.codegen.NamingStrategy;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class KeyDataFactoryTest
extends AbstractJDBCTest {
    @Test
    public void test() throws SQLException {
        this.statement.execute("drop table employee if exists");
        this.statement.execute("drop table survey if exists");
        this.statement.execute("drop table date_test if exists");
        this.statement.execute("drop table date_time_test if exists");
        this.statement.execute("create table survey (id int, name varchar(30), CONSTRAINT PK_survey PRIMARY KEY (id, name))");
        this.statement.execute("create table employee(id INT, superior_id int, superior_id2 int, survey_id int, survey_name varchar(30), CONSTRAINT PK_employee PRIMARY KEY (id), CONSTRAINT FK_survey FOREIGN KEY (survey_id, survey_name) REFERENCES survey(id,name), CONSTRAINT FK_superior2 FOREIGN KEY (superior_id) REFERENCES employee(id), CONSTRAINT FK_superior1 FOREIGN KEY (superior_id2) REFERENCES employee(id))");
        KeyDataFactory keyDataFactory = new KeyDataFactory((NamingStrategy)new DefaultNamingStrategy(), "Q", "", "test", false);
        DatabaseMetaData md = this.connection.getMetaData();
        Map primaryKeys = keyDataFactory.getPrimaryKeys(md, null, null, "EMPLOYEE");
        Assertions.assertThat((Map)primaryKeys).isNotEmpty();
        Map exportedKeys = keyDataFactory.getExportedKeys(md, null, null, "EMPLOYEE");
        Assertions.assertThat((Map)exportedKeys).hasSize(2);
        Iterator exportedKeysIterator = exportedKeys.keySet().iterator();
        Assertions.assertThat((String)((String)exportedKeysIterator.next())).isEqualTo("FK_SUPERIOR1");
        Assertions.assertThat((String)((String)exportedKeysIterator.next())).isEqualTo("FK_SUPERIOR2");
        Map importedKeys = keyDataFactory.getImportedKeys(md, null, null, "EMPLOYEE");
        Assertions.assertThat((Map)importedKeys).hasSize(3);
        Iterator importedKeysIterator = importedKeys.keySet().iterator();
        Assertions.assertThat((String)((String)importedKeysIterator.next())).isEqualTo("FK_SUPERIOR1");
        Assertions.assertThat((String)((String)importedKeysIterator.next())).isEqualTo("FK_SUPERIOR2");
        Assertions.assertThat((String)((String)importedKeysIterator.next())).isEqualTo("FK_SURVEY");
        primaryKeys = keyDataFactory.getPrimaryKeys(md, null, null, "SURVEY");
        Assertions.assertThat((Map)primaryKeys).isNotEmpty();
        exportedKeys = keyDataFactory.getExportedKeys(md, null, null, "SURVEY");
        Assertions.assertThat((Map)exportedKeys).isNotEmpty();
        Assertions.assertThat((Map)exportedKeys).containsKey((Object)"FK_SURVEY");
        importedKeys = keyDataFactory.getImportedKeys(md, null, null, "SURVEY");
        Assertions.assertThat((Map)importedKeys).isEmpty();
    }
}

