/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.utils.SimpleCompiler;
import com.querydsl.core.testutil.Parallelized;
import com.querydsl.core.testutil.SlowTest;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.MetaDataExporterTest;
import com.querydsl.sql.codegen.MetadataExporterConfig;
import com.querydsl.sql.codegen.MetadataExporterConfigImpl;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.OrdinalPositionComparator;
import com.querydsl.sql.codegen.OriginalNamingStrategy;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.tools.JavaCompiler;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parallelized.class)
@Category(value={SlowTest.class})
public class MetaDataExporterAllTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static Connection connection;
    private static DatabaseMetaData metadata;
    private static JavaCompiler compiler;
    private String namePrefix;
    private String nameSuffix;
    private String beanPrefix;
    private String beanSuffix;
    private String beanPackageName;
    private Class<? extends BeanSerializer> beanSerializer = BeanSerializer.class;
    private Class<? extends NamingStrategy> namingStrategyClass;
    private boolean withBeans;
    private boolean withInnerClasses;
    private boolean withOrdinalPositioning;
    private boolean exportColumns;
    private boolean schemaToPackage;

    @BeforeClass
    public static void setUpClass() throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        String url = "jdbc:h2:mem:testdb" + System.currentTimeMillis() + ";MODE=legacy";
        connection = DriverManager.getConnection(url, "sa", "");
        metadata = connection.getMetaData();
        MetaDataExporterTest.createTables(connection);
    }

    @AfterClass
    public static void tearDownClass() throws SQLException {
        connection.close();
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List<Class> ns = Arrays.asList(DefaultNamingStrategy.class, OriginalNamingStrategy.class);
        List<String> prefixOrSuffix = Arrays.asList("", "Q");
        List<String> beanPackage = Arrays.asList(null, "test2");
        List<Boolean> booleans = Arrays.asList(true, false);
        for (String namePrefix : prefixOrSuffix) {
            for (String nameSuffix : prefixOrSuffix) {
                for (String beanPrefix : prefixOrSuffix) {
                    for (String beanSuffix : prefixOrSuffix) {
                        for (String beanPackageName : beanPackage) {
                            for (Class namingStrategy : ns) {
                                for (boolean withBeans : booleans) {
                                    for (boolean withInnerClasses : booleans) {
                                        for (boolean withOrdinalPositioning : booleans) {
                                            for (boolean exportColumns : booleans) {
                                                for (boolean schemaToPackage : booleans) {
                                                    if (withBeans && beanPackageName == null && Objects.equals(namePrefix, beanPrefix) && Objects.equals(nameSuffix, beanSuffix) || withInnerClasses && withOrdinalPositioning) continue;
                                                    params.add(new Object[]{namePrefix, nameSuffix, beanPrefix, beanSuffix, beanPackageName, namingStrategy, withBeans, withInnerClasses, withOrdinalPositioning, exportColumns, schemaToPackage});
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return params;
    }

    public MetaDataExporterAllTest(String namePrefix, String nameSuffix, String beanPrefix, String beanSuffix, String beanPackageName, Class<? extends NamingStrategy> namingStrategy, boolean withBeans, boolean withInnerClasses, boolean withOrdinalPositioning, boolean exportColumns, boolean schemaToPackage) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.beanPrefix = beanPrefix;
        this.beanSuffix = beanSuffix;
        this.beanPackageName = beanPackageName;
        this.schemaToPackage = schemaToPackage;
        this.namingStrategyClass = namingStrategy;
        this.withBeans = withBeans;
        this.withInnerClasses = withInnerClasses;
        this.withOrdinalPositioning = withOrdinalPositioning;
        this.exportColumns = exportColumns;
    }

    @Test
    public void export() throws SQLException, IOException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setColumnAnnotations(this.exportColumns);
        config.setSchemaPattern("PUBLIC");
        config.setNamePrefix(this.namePrefix);
        config.setNameSuffix(this.nameSuffix);
        config.setBeanPrefix(this.beanPrefix);
        config.setBeanSuffix(this.beanSuffix);
        config.setInnerClassesForKeys(this.withInnerClasses);
        config.setPackageName("test");
        config.setBeanPackageName(this.beanPackageName);
        config.setTargetFolder(this.folder.getRoot());
        config.setNamingStrategyClass(this.namingStrategyClass);
        config.setSchemaToPackage(this.schemaToPackage);
        if (this.withBeans) {
            config.setBeanSerializerClass(this.beanSerializer);
        }
        if (this.withOrdinalPositioning) {
            config.setColumnComparatorClass(OrdinalPositionComparator.class);
        }
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(metadata);
        Set classes = exporter.getClasses();
        int compilationResult = compiler.run(null, System.out, System.err, classes.toArray(new String[0]));
        if (compilationResult != 0) {
            Assertions.fail((String)("Compilation Failed for " + this.folder.getRoot().getPath()));
        }
    }

    static {
        compiler = new SimpleCompiler();
    }
}

