/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.utils.SimpleCompiler;
import com.querydsl.core.util.FileUtils;
import com.querydsl.core.util.ReflectionUtils;
import com.querydsl.sql.Connections;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.MetadataExporterConfig;
import com.querydsl.sql.codegen.MetadataExporterConfigImpl;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.OrdinalPositionComparator;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import javax.tools.JavaCompiler;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class MetaDataExporterTest {
    private static Connection connection;
    private boolean clean = true;
    private boolean exportColumns = false;
    private boolean schemaToPackage = false;
    private DatabaseMetaData metadata;
    private JavaCompiler compiler = new SimpleCompiler();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private String beanPackageName = null;

    @BeforeClass
    public static void setUpClass() throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        String url = "jdbc:h2:mem:testdb" + System.currentTimeMillis() + ";MODE=legacy";
        connection = DriverManager.getConnection(url, "sa", "");
        MetaDataExporterTest.createTables(connection);
    }

    static void createTables(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("create table reserved (id int, while int)");
            stmt.execute("create table class (id int)");
            stmt.execute("create table underscore (e_id int, c_id int)");
            stmt.execute("create table beangen1 (\"SEP_Order\" int)");
            stmt.execute("create table definstance (id int, definstance int, definstance1 int)");
            stmt.execute("create table pkfk (id int primary key, pk int, fk int)");
            stmt.execute("create table \"camelCase\" (id int)");
            stmt.execute("create table \"vwServiceName\" (id int)");
            stmt.execute("create table date_test (d date)");
            stmt.execute("create table date_time_test (dt datetime)");
            stmt.execute("create table survey (id int, name varchar(30))");
            stmt.execute("create table \"new\nline\" (id int)");
            stmt.execute("create table newline2 (id int, \"new\nline\" int)");
            stmt.execute("create table employee(id INT, firstname VARCHAR(50), lastname VARCHAR(50), salary DECIMAL(10, 2), datefield DATE, timefield TIME, superior_id int, survey_id int, survey_name varchar(30), CONSTRAINT PK_employee PRIMARY KEY (id), CONSTRAINT FK_superior FOREIGN KEY (superior_id) REFERENCES employee(id))");
            stmt.execute("create table multikey(id INT, id2 VARCHAR, id3 INT, CONSTRAINT pk_multikey PRIMARY KEY (id, id2, id3) )");
            stmt.execute("create table product(id int, m_product_bom_id int, m_productbom_id int, constraint product_bom foreign key (m_productbom_id) references product(id))");
        }
    }

    @AfterClass
    public static void tearDownClass() throws SQLException {
        connection.close();
    }

    @Before
    public void setUp() throws ClassNotFoundException, SQLException {
        this.metadata = connection.getMetaData();
    }

    @Test
    public void normalSettings_repetition() throws SQLException {
        this.test("Q", "", "", "", DefaultNamingStrategy.class, this.folder.getRoot(), false, false, false);
        File file = new File(this.folder.getRoot(), "test/QEmployee.java");
        long lastModified = file.lastModified();
        Assertions.assertThat((File)file).exists();
        this.clean = false;
        this.test("Q", "", "", "", DefaultNamingStrategy.class, this.folder.getRoot(), false, false, false);
        Assertions.assertThat((long)file.lastModified()).isEqualTo(lastModified);
    }

    @Test
    public void explicit_configuration() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setCatalogPattern(connection.getCatalog());
        config.setSchemaPattern("PUBLIC");
        config.setNamePrefix("Q");
        config.setPackageName("test");
        config.setTargetFolder(this.folder.getRoot());
        config.setNamingStrategyClass(DefaultNamingStrategy.class);
        config.setBeanSerializerClass(BeanSerializer.class);
        config.setBeanPackageName("test2");
        config.setExportBeans(true);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QDateTest.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test2/DateTest.java")).exists();
    }

    @Test
    public void validation_annotations_are_not_added_to_columns_with_default_values() throws SQLException, ClassNotFoundException, MalformedURLException {
        Statement stmt = connection.createStatement();
        stmt.execute("CREATE TABLE foo (id INTEGER PRIMARY KEY AUTO_INCREMENT NOT NULL,name VARCHAR(255) NOT NULL DEFAULT 'some default')");
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setNamePrefix("Q");
        config.setPackageName("test");
        config.setTableNamePattern("FOO");
        config.setTargetFolder(this.folder.getRoot());
        config.setBeanSerializerClass(BeanSerializer.class);
        config.setValidationAnnotations(true);
        config.setExportBeans(true);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{this.folder.getRoot().toURI().toURL()});
        this.compiler.run(null, null, null, String.valueOf(this.folder.getRoot().getAbsoluteFile()) + "/test/Foo.java");
        Class<?> cls = Class.forName("test.Foo", true, classLoader);
        Assertions.assertThat((Object)ReflectionUtils.getAnnotatedElement(cls, (String)"id", Integer.class).getAnnotation(NotNull.class)).isNotNull();
        Assertions.assertThat((Object)ReflectionUtils.getAnnotatedElement(cls, (String)"name", String.class).getAnnotation(NotNull.class)).isNull();
        stmt.execute("DROP TABLE foo");
    }

    @Test
    public void validation_annotations_are_added_to_columns_without_default_values() throws SQLException, ClassNotFoundException, MalformedURLException {
        Statement stmt = connection.createStatement();
        stmt.execute("CREATE TABLE bar (id VARCHAR(10) PRIMARY KEY NOT NULL,name VARCHAR(255) NOT NULL)");
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setNamePrefix("Q");
        config.setPackageName("test");
        config.setTableNamePattern("BAR");
        config.setTargetFolder(this.folder.getRoot());
        config.setBeanSerializerClass(BeanSerializer.class);
        config.setValidationAnnotations(true);
        config.setExportBeans(true);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        File file = new File(this.folder.getRoot().getAbsoluteFile(), "/test/Bar.java");
        Assertions.assertThat((boolean)file.exists());
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{this.folder.getRoot().toURI().toURL()});
        this.compiler.run(null, null, null, file.toString());
        Class<?> cls = Class.forName("test.Bar", true, classLoader);
        Assertions.assertThat((Object)ReflectionUtils.getAnnotatedElement(cls, (String)"id", Integer.class).getAnnotation(NotNull.class)).isNotNull();
        Assertions.assertThat((Object)ReflectionUtils.getAnnotatedElement(cls, (String)"name", String.class).getAnnotation(NotNull.class)).isNotNull();
        stmt.execute("DROP TABLE bar");
    }

    @Test
    public void minimal_configuration() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setPackageName("test");
        config.setTargetFolder(this.folder.getRoot());
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QDateTest.java")).exists();
    }

    @Test
    public void minimal_configuration_with_schemas() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC2,PUBLIC");
        config.setPackageName("test");
        config.setTargetFolder(this.folder.getRoot());
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QDateTest.java")).exists();
    }

    @Test
    public void minimal_configuration_with_schemas_and_tables() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC2,PUBLIC");
        config.setTableNamePattern("RESERVED,UNDERSCORE,BEANGEN1");
        config.setPackageName("test");
        config.setTargetFolder(this.folder.getRoot());
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QBeangen1.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QReserved.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QUnderscore.java")).exists();
        Assertions.assertThat((boolean)new File(this.folder.getRoot(), "test/QDefinstance.java").exists()).isFalse();
    }

    @Test
    public void minimal_configuration_with_tables() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setTableNamePattern("RESERVED,UNDERSCORE,BEANGEN1");
        config.setPackageName("test");
        config.setTargetFolder(this.folder.getRoot());
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QBeangen1.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QReserved.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QUnderscore.java")).exists();
        Assertions.assertThat((boolean)new File(this.folder.getRoot(), "test/QDefinstance.java").exists()).isFalse();
    }

    @Test(expected=IllegalStateException.class)
    public void minimal_configuration_with_duplicate_tables() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setTableNamePattern("%,%");
        config.setPackageName("test");
        config.setTargetFolder(this.folder.getRoot());
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QBeangen1.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QReserved.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/QUnderscore.java")).exists();
        Assertions.assertThat((boolean)new File(this.folder.getRoot(), "test/QDefinstance.java").exists()).isFalse();
    }

    @Test
    public void minimal_configuration_with_suffix() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setPackageName("test");
        config.setNamePrefix("");
        config.setNameSuffix("Type");
        config.setTargetFolder(this.folder.getRoot());
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/DateTestType.java")).exists();
    }

    @Test
    public void minimal_configuration_without_keys() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setPackageName("test");
        config.setNamePrefix("");
        config.setNameSuffix("Type");
        config.setTargetFolder(this.folder.getRoot());
        config.setExportForeignKeys(false);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/DateTestType.java")).exists();
    }

    @Test
    public void minimal_configuration_only_direct_foreign_keys() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setPackageName("test");
        config.setNamePrefix("");
        config.setNameSuffix("Type");
        config.setTargetFolder(this.folder.getRoot());
        config.setExportInverseForeignKeys(false);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/DateTestType.java")).exists();
    }

    @Test
    public void minimal_configuration_with_bean_prefix() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setPackageName("test");
        config.setNamePrefix("");
        config.setBeanPrefix("Bean");
        config.setBeanSerializerClass(BeanSerializer.class);
        config.setTargetFolder(this.folder.getRoot());
        config.setExportBeans(true);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/DateTest.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/BeanDateTest.java")).exists();
    }

    @Test
    public void minimal_configuration_with_bean_suffix() throws SQLException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setPackageName("test");
        config.setNamePrefix("");
        config.setBeanSuffix("Bean");
        config.setBeanSerializerClass(BeanSerializer.class);
        config.setTargetFolder(this.folder.getRoot());
        config.setExportBeans(true);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/DateTest.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/DateTestBean.java")).exists();
    }

    @Test
    public void minimal_configuration_with_bean_folder() throws SQLException, IOException {
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setSchemaPattern("PUBLIC");
        config.setPackageName("test");
        config.setNamePrefix("");
        config.setBeanSuffix("Bean");
        config.setBeanSerializerClass(BeanSerializer.class);
        config.setTargetFolder(this.folder.getRoot());
        config.setBeansTargetFolder(this.folder.newFolder("beans"));
        config.setExportBeans(true);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Assertions.assertThat((File)new File(this.folder.getRoot(), "test/DateTest.java")).exists();
        Assertions.assertThat((File)new File(this.folder.getRoot(), "beans/test/DateTestBean.java")).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void catalog_pattern() throws SQLException, IOException, ClassNotFoundException {
        Connections.initMySQL();
        Connection connection = Connections.getConnection();
        Statement stmt = Connections.getStatement();
        try {
            stmt.execute("CREATE DATABASE IF NOT EXISTS catalog_test_one");
            stmt.execute("CREATE TABLE IF NOT EXISTS catalog_test_one.test_catalog_table_one(id INT PRIMARY KEY, foo VARCHAR(32) NOT NULL)");
            stmt.execute("CREATE DATABASE IF NOT EXISTS catalog_test_two");
            stmt.execute("CREATE TABLE IF NOT EXISTS catalog_test_two.test_catalog_table_two(id INT PRIMARY KEY, foo VARCHAR(32) NOT NULL)");
            MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
            config.setSchemaPattern("PUBLIC");
            config.setCatalogPattern("catalog_test_one");
            config.setPackageName("test");
            config.setNamePrefix("");
            config.setBeanSuffix("Bean");
            config.setBeanSerializerClass(BeanSerializer.class);
            config.setTargetFolder(this.folder.getRoot());
            config.setBeansTargetFolder(this.folder.newFolder("beans"));
            MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
            exporter.export(connection.getMetaData());
            Assertions.assertThat((File)new File(this.folder.getRoot(), "test/TestCatalogTableOne.java")).exists();
            Assertions.assertThat((File)new File(this.folder.getRoot(), "beans/test/TestCatalogTableOneBean.java")).exists();
            Assertions.assertThat((boolean)new File(this.folder.getRoot(), "test/TestCatalogTableTwo.java").exists()).isFalse();
            Assertions.assertThat((boolean)new File(this.folder.getRoot(), "beans/test/TestCatalogTableTwoBean.java").exists()).isFalse();
            config.setCatalogPattern("catalog_test_two");
            exporter.export(connection.getMetaData());
            Assertions.assertThat((File)new File(this.folder.getRoot(), "test/TestCatalogTableTwo.java")).exists();
            Assertions.assertThat((File)new File(this.folder.getRoot(), "beans/test/TestCatalogTableTwoBean.java")).exists();
        }
        finally {
            stmt.execute("DROP DATABASE IF EXISTS catalog_test_one");
            stmt.execute("DROP DATABASE IF EXISTS catalog_test_two");
            stmt.close();
            Connections.close();
        }
    }

    private void test(String namePrefix, String nameSuffix, String beanPrefix, String beanSuffix, Class<? extends NamingStrategy> namingStrategy, File targetDir, boolean withBeans, boolean withInnerClasses, boolean withOrdinalPositioning) throws SQLException {
        if (this.clean) {
            try {
                if (targetDir.exists()) {
                    FileUtils.delete((File)targetDir);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setColumnAnnotations(this.exportColumns);
        config.setSchemaPattern("PUBLIC");
        config.setNamePrefix(namePrefix);
        config.setNameSuffix(nameSuffix);
        config.setBeanPrefix(beanPrefix);
        config.setBeanSuffix(beanSuffix);
        config.setInnerClassesForKeys(withInnerClasses);
        config.setPackageName("test");
        config.setBeanPackageName(this.beanPackageName);
        config.setTargetFolder(targetDir);
        config.setNamingStrategyClass(namingStrategy);
        config.setSchemaToPackage(this.schemaToPackage);
        if (withBeans) {
            config.setBeanSerializerClass(BeanSerializer.class);
        }
        if (withOrdinalPositioning) {
            config.setColumnComparatorClass(OrdinalPositionComparator.class);
        }
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.export(this.metadata);
        Set classes = exporter.getClasses();
        int compilationResult = this.compiler.run(null, System.out, System.err, classes.toArray(new String[0]));
        if (compilationResult != 0) {
            Assertions.fail((String)("Compilation Failed for " + targetDir.getAbsolutePath()));
        }
    }
}

