/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import jakarta.inject.Inject;
import jakarta.inject.Named;

public final class SQLQueryTypeFactory
implements QueryTypeFactory {
    private final String packageName;
    private final String beanPackageName;
    private final int stripStart;
    private final int stripEnd;
    private final String prefix;
    private final String suffix;
    private final boolean replacePackage;

    @Inject
    public SQLQueryTypeFactory(@Named(value="packageName") String packageName, @Named(value="beanPackageName") String beanPackageName, @Named(value="beanPrefix") String beanPrefix, @Named(value="beanSuffix") String beanSuffix, @Named(value="prefix") String prefix, @Named(value="suffix") String suffix) {
        this.packageName = packageName;
        this.beanPackageName = beanPackageName;
        this.replacePackage = !packageName.equals(beanPackageName);
        this.stripStart = beanPrefix.length();
        this.stripEnd = beanSuffix.length();
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public Type create(Type type) {
        Object packageName = type.getPackageName();
        if (this.replacePackage) {
            packageName = this.packageName + ((String)packageName).substring(this.beanPackageName.length());
        }
        Object simpleName = type.getSimpleName();
        simpleName = this.prefix + ((String)simpleName).substring(this.stripStart, ((String)simpleName).length() - this.stripEnd) + this.suffix;
        return new SimpleType((String)packageName + "." + (String)simpleName, (String)packageName, (String)simpleName, new Type[0]);
    }
}

