/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.core.alias.Gender;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.AbstractJDBCTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.EncryptedString;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.QPerson;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.MetadataExporterConfig;
import com.querydsl.sql.codegen.MetadataExporterConfigImpl;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import com.querydsl.sql.types.EnumByNameType;
import com.querydsl.sql.types.StringType;
import com.querydsl.sql.types.Type;
import com.querydsl.sql.types.UtilDateType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class CustomTypesTest
extends AbstractJDBCTest {
    private Configuration configuration;

    @Before
    public void setUp() throws ClassNotFoundException, SQLException {
        super.setUp();
        this.statement.execute("drop table person if exists");
        this.statement.execute("create table person(id INT, firstname VARCHAR(50), gender VARCHAR(50), securedId VARCHAR(50), CONSTRAINT PK_person PRIMARY KEY (id) )");
        this.configuration = new Configuration((SQLTemplates)new HSQLDBTemplates());
        this.configuration.register((Type)new UtilDateType());
        this.configuration.register("PERSON", "SECUREDID", (Type)new EncryptedString());
        this.configuration.register("PERSON", "GENDER", (Type)new EnumByNameType(Gender.class));
        this.configuration.register((Type)new StringType());
    }

    @Test
    public void export() throws SQLException, IOException {
        String namePrefix = "Q";
        MetadataExporterConfigImpl config = new MetadataExporterConfigImpl();
        config.setNamePrefix(namePrefix);
        config.setPackageName("test");
        config.setTargetFolder(new File("target/customExport"));
        config.setNamingStrategyClass(DefaultNamingStrategy.class);
        MetaDataExporter exporter = new MetaDataExporter((MetadataExporterConfig)config);
        exporter.setConfiguration(this.configuration);
        exporter.export(this.connection.getMetaData());
        java.nio.file.Path qpersonFile = java.nio.file.Path.of("target", "customExport", "test", "QPerson.java");
        Assertions.assertThat((java.nio.file.Path)qpersonFile).exists();
        String person = new String(Files.readAllBytes(qpersonFile), StandardCharsets.UTF_8);
        Assertions.assertThat((String)person).contains(new CharSequence[]{"createEnum(\"gender\""});
    }

    @Test
    public void insert_query_update() {
        QPerson person = QPerson.person;
        SQLInsertClause insert = new SQLInsertClause(this.connection, this.configuration, (RelationalPath)person);
        insert.set((Path)person.id, (Object)10);
        insert.set((Path)person.firstname, (Object)"Bob");
        insert.set((Path)person.gender, (Object)Gender.MALE);
        Assertions.assertThat((long)insert.execute()).isEqualTo(1L);
        SQLQuery query = new SQLQuery(this.connection, this.configuration);
        Assertions.assertThat((Comparable)((Gender)((SQLQuery)((SQLQuery)query.from((RelationalPath)person)).where((Predicate)person.id.eq((Object)10))).select((Expression)person.gender).fetchOne())).isEqualTo((Object)Gender.MALE);
        SQLUpdateClause update = new SQLUpdateClause(this.connection, this.configuration, (RelationalPath)person);
        update.set((Path)person.gender, (Object)Gender.FEMALE);
        update.set((Path)person.firstname, (Object)"Jane");
        update.where((Predicate)person.id.eq((Object)10));
        update.execute();
        query = new SQLQuery(this.connection, this.configuration);
        Assertions.assertThat((Comparable)((Gender)((SQLQuery)((SQLQuery)query.from((RelationalPath)person)).where((Predicate)person.id.eq((Object)10))).select((Expression)person.gender).fetchOne())).isEqualTo((Object)Gender.FEMALE);
    }
}

