/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.NamingStrategy;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class DefaultNamingStrategyTest {
    private NamingStrategy namingStrategy = new DefaultNamingStrategy();
    private EntityType entityModel;

    @Before
    public void setUp() {
        this.entityModel = new EntityType((Type)Types.OBJECT);
        this.entityModel.getData().put("table", "OBJECT");
    }

    @Test
    public void getClassName() {
        Assertions.assertThat((String)this.namingStrategy.getClassName("user_data")).isEqualTo("UserData");
        Assertions.assertThat((String)this.namingStrategy.getClassName("u")).isEqualTo("U");
        Assertions.assertThat((String)this.namingStrategy.getClassName("us")).isEqualTo("Us");
        Assertions.assertThat((String)this.namingStrategy.getClassName("u_")).isEqualTo("U_");
        Assertions.assertThat((String)this.namingStrategy.getClassName("us_")).isEqualTo("Us_");
        Assertions.assertThat((String)this.namingStrategy.getClassName("new line")).isEqualTo("NewLine");
    }

    @Test
    public void getPropertyName() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("a", this.entityModel)).isEqualTo("a");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("while", this.entityModel)).isEqualTo("whileCol");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("name", this.entityModel)).isEqualTo("name");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("user_id", this.entityModel)).isEqualTo("userId");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("accountEvent_id", this.entityModel)).isEqualTo("accountEventId");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("123abc", this.entityModel)).isEqualTo("_123abc");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("123 abc", this.entityModel)).isEqualTo("_123Abc");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("#123#abc#def", this.entityModel)).isEqualTo("_123AbcDef");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("new line", this.entityModel)).isEqualTo("newLine");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("class", this.entityModel)).isEqualTo("classCol");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("Class", this.entityModel)).isEqualTo("classCol");
    }

    @Test
    public void getPropertyName_with_dashes() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("A-FOOBAR", this.entityModel)).isEqualTo("aFoobar");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("A_FOOBAR", this.entityModel)).isEqualTo("aFoobar");
    }

    @Test
    public void getPropertyName_for_column_with_spaces() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("user id", this.entityModel)).isEqualTo("userId");
    }

    @Test
    public void getPropertyNameForInverseForeignKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForInverseForeignKey("fk_superior", this.entityModel)).isEqualTo("_superiorFk");
    }

    @Test
    public void getPropertyNameForForeignKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("fk_superior", this.entityModel)).isEqualTo("superiorFk");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("FK_SUPERIOR", this.entityModel)).isEqualTo("superiorFk");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("REFFOO_BAR", this.entityModel)).isEqualTo("reffooBar");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("REF_FOO_BAR", this.entityModel)).isEqualTo("refFooBar");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForForeignKey("REF_FOO_BAR_", this.entityModel)).isEqualTo("refFooBar_");
    }

    @Test
    public void getPropertyNameForPrimaryKey() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForPrimaryKey("pk_superior", this.entityModel)).isEqualTo("superiorPk");
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForPrimaryKey("PK_SUPERIOR", this.entityModel)).isEqualTo("superiorPk");
    }

    @Test
    public void getPropertyNameForPrimaryKey_clash() {
        this.entityModel.addProperty(new Property(this.entityModel, "id", (Type)Types.STRING));
        Assertions.assertThat((String)this.namingStrategy.getPropertyNameForPrimaryKey("id", this.entityModel)).isEqualTo("idPk");
    }

    @Test
    public void getDefaultVariableName() {
        Assertions.assertThat((String)this.namingStrategy.getDefaultVariableName(this.entityModel)).isEqualTo("object");
    }

    @Test
    public void spaces() {
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("a  b", this.entityModel)).isEqualTo("a_b");
    }

    @Test
    public void validName() {
        Assertions.assertThat((String)this.namingStrategy.normalizeColumnName("8FRecord")).isEqualTo("8FRecord");
        Assertions.assertThat((String)this.namingStrategy.getPropertyName("8FRecord", this.entityModel)).isEqualTo("_8FRecord");
    }
}

