/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.buffer;

import io.github.opensabe.common.buffer.BatchBufferedCountDownQueue;
import io.github.opensabe.common.buffer.BufferedCountDownLatchWithResultElement;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public abstract class BatchBufferedCountDownWithResultQueue<T, E extends BufferedCountDownLatchWithResultElement<T>>
extends BatchBufferedCountDownQueue<E> {
    private ThreadLocal<List<T>> result = new ThreadLocal();

    @Override
    protected void batchManipulate(List<E> batch) {
        this.result.set(this.batchManipulateWithResult(batch));
    }

    @Override
    protected void afterBatchFinish(List<E> batch) {
        List<T> list = this.result.get();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((BufferedCountDownLatchWithResultElement)batch.get(i)).finish(list.get(i));
        }
    }

    @NotNull
    protected abstract List<T> batchManipulateWithResult(List<E> var1);
}

