/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.buffer;

import io.github.opensabe.common.buffer.BufferedElement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BufferedCountDownLatchElement
extends BufferedElement {
    @Generated
    private static final Logger log = LogManager.getLogger(BufferedCountDownLatchElement.class);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private volatile Throwable throwable;

    void waitUntilFinish() {
        boolean completed = false;
        long startTime = System.currentTimeMillis();
        while (!completed) {
            try {
                this.countDownLatch.await();
                completed = true;
                log.info("BufferedCountDownLatchElement-waitUntilFinish origin traceId: {} spanId: {} elapsed {}ms", (Object)this.traceId(), (Object)this.spanId(), (Object)(System.currentTimeMillis() - startTime));
            }
            catch (Throwable e) {
                log.info("BufferedCountDownLatchElement-waitUntilFinish await error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (this.throwable != null) {
            throw new RuntimeException(this.throwable);
        }
    }

    void finish() {
        if (this.finished.compareAndSet(false, true)) {
            this.countDownLatch.countDown();
        }
    }

    public void error(Throwable throwable) {
        this.throwable = throwable;
        this.finish();
    }
}

