/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.buffer;

import io.github.opensabe.common.buffer.BufferedElementJFREvent;
import jakarta.persistence.Transient;

public abstract class BufferedElement {
    private final BufferedElementJFREvent bufferedElementJFREvent = new BufferedElementJFREvent();
    @Transient
    private String traceId;
    @Transient
    private String spanId;

    protected BufferedElement() {
        this.bufferedElementJFREvent.begin();
    }

    public abstract String hashKey();

    public String traceId() {
        return this.traceId;
    }

    public String spanId() {
        return this.spanId;
    }

    public void setSubmitInfo(String traceId, String spanId) {
        this.traceId = traceId;
        this.bufferedElementJFREvent.setSubmitTraceId(traceId);
        this.spanId = spanId;
        this.bufferedElementJFREvent.setSubmitSpanId(spanId);
    }

    public void beforeElementManipulate(String spanId) {
        this.bufferedElementJFREvent.setQueueTime(System.currentTimeMillis() - this.bufferedElementJFREvent.getSubmitTime());
        this.bufferedElementJFREvent.setBatchSpanId(spanId);
    }

    public void afterElementManipulate() {
        this.bufferedElementJFREvent.commit();
    }

    public void afterElementManipulateError(Throwable throwable) {
        this.bufferedElementJFREvent.setError(throwable.getMessage());
        this.bufferedElementJFREvent.commit();
    }
}

