/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.bytecode;

import io.github.opensabe.common.bytecode.BeanCopier;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class ByteBuddyBeanCopier<S, T>
implements BeanCopier<S, T> {
    private final List<PropertyTransformer> propertyTransformers;

    protected ByteBuddyBeanCopier(Class<S> source, Class<T> target) {
        Map<String, PropertyDescriptor> getters = Arrays.stream(BeanUtils.getPropertyDescriptors(source)).filter(p -> Objects.nonNull(p.getReadMethod())).collect(Collectors.toMap(FeatureDescriptor::getName, p -> p));
        this.propertyTransformers = Arrays.stream(BeanUtils.getPropertyDescriptors(target)).filter(p -> Objects.nonNull(p.getWriteMethod())).filter(p -> getters.containsKey(p.getName())).filter(p -> ByteBuddyBeanCopier.isAssignable((PropertyDescriptor)getters.get(p.getName()), p)).map(p -> new PropertyTransformer(this, (PropertyDescriptor)getters.get(p.getName()), (PropertyDescriptor)p)).toList();
    }

    public static <S, T> ByteBuddyBeanCopier<S, T> create(Class<S> source, Class<T> target) {
        ByteBuddyBeanCopier byteBuddyBeanCopier;
        block8: {
            DynamicType.Unloaded unloaded = new ByteBuddy(ClassFileVersion.ofThisVm()).subclass(ByteBuddyBeanCopier.class).method((ElementMatcher)ElementMatchers.named((String)"copy").and((ElementMatcher)ElementMatchers.isAbstract())).intercept((Implementation)MethodDelegation.to(new Interceptor())).make();
            try {
                Class service = unloaded.load(ByteBuddyBeanCopier.class.getClassLoader()).getLoaded();
                byteBuddyBeanCopier = (ByteBuddyBeanCopier)ReflectionUtils.accessibleConstructor((Class)service, (Class[])new Class[]{Class.class, Class.class}).newInstance(source, target);
                if (unloaded == null) break block8;
            }
            catch (Throwable throwable) {
                if (unloaded != null) {
                    try {
                        unloaded.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            unloaded.close();
        }
        return byteBuddyBeanCopier;
    }

    private static boolean isAssignable(PropertyDescriptor source, PropertyDescriptor target) {
        Method readMethod = source.getReadMethod();
        Method writeMethod = target.getWriteMethod();
        if (writeMethod == null || readMethod == null) {
            return false;
        }
        ResolvableType sourceResolvableType = ResolvableType.forMethodReturnType((Method)readMethod);
        ResolvableType targetResolvableType = ResolvableType.forMethodParameter((Method)writeMethod, (int)0);
        Type paramType = writeMethod.getGenericParameterTypes()[0];
        if (paramType instanceof Class) {
            Class clazz = (Class)paramType;
            return ClassUtils.isAssignable((Class)clazz, readMethod.getReturnType());
        }
        if (paramType.equals(readMethod.getGenericReturnType())) {
            return true;
        }
        return sourceResolvableType.hasUnresolvableGenerics() || targetResolvableType.hasUnresolvableGenerics() ? ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType()) : targetResolvableType.isAssignableFrom(sourceResolvableType);
    }

    public static class Interceptor<S, T> {
        public void doCopy(@Argument(value=0) S source, @Argument(value=1) T target, @This ByteBuddyBeanCopier<S, T> thi) {
            thi.propertyTransformers.forEach(t -> t.invoke(source, target));
        }
    }

    class PropertyTransformer {
        private final Method getter;
        private final Method setter;

        PropertyTransformer(ByteBuddyBeanCopier this$0, Method getter, Method setter) {
            this.getter = getter;
            this.setter = setter;
        }

        PropertyTransformer(ByteBuddyBeanCopier this$0, PropertyDescriptor getter, PropertyDescriptor setter) {
            this(this$0, getter.getReadMethod(), setter.getWriteMethod());
        }

        void invoke(S source, T target) {
            this.setter.invoke(target, this.getter.invoke(source, new Object[0]));
        }
    }
}

