/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.future;

import io.github.opensabe.common.observation.UnifiedObservationFactory;
import io.micrometer.observation.Observation;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CompletableFutureWithSpan<T>
extends CompletableFuture<T> {
    private final CompletableFuture<T> completableFuture;
    private final Observation observation;

    CompletableFutureWithSpan(CompletableFuture<T> completableFuture, Observation observation) {
        this.completableFuture = completableFuture;
        this.observation = observation;
    }

    private static <T> CompletableFutureWithSpan<T> from(CompletableFuture<T> completableFuture, UnifiedObservationFactory unifiedObservationFactory) {
        return CompletableFutureWithSpan.from(completableFuture, unifiedObservationFactory.getCurrentOrCreateEmptyObservation());
    }

    private static <T> CompletableFutureWithSpan<T> from(CompletableFuture<T> completableFuture, Observation observation) {
        return new CompletableFutureWithSpan<T>(completableFuture, observation);
    }

    public static CompletableFutureWithSpan<Void> allOf(UnifiedObservationFactory unifiedObservationFactory, CompletableFutureWithSpan<?> ... cfs) {
        CompletableFuture[] completableFutures = Arrays.stream(cfs).map(completableFutureWithSpan -> completableFutureWithSpan.completableFuture).collect(Collectors.toList()).toArray(new CompletableFuture[0]);
        return CompletableFutureWithSpan.from(CompletableFuture.allOf(completableFutures), unifiedObservationFactory);
    }

    public static CompletableFuture<Object> anyOf(UnifiedObservationFactory unifiedObservationFactory, CompletableFutureWithSpan<?> ... cfs) {
        CompletableFuture[] completableFutures = Arrays.stream(cfs).map(completableFutureWithSpan -> completableFutureWithSpan.completableFuture).collect(Collectors.toList()).toArray(new CompletableFuture[0]);
        return CompletableFutureWithSpan.from(CompletableFuture.anyOf(completableFutures), unifiedObservationFactory);
    }

    public static <U> CompletableFutureWithSpan<U> supplyAsync(Supplier<U> supplier, UnifiedObservationFactory unifiedObservationFactory) {
        Observation observation = unifiedObservationFactory.getCurrentOrCreateEmptyObservation();
        return CompletableFutureWithSpan.from(CompletableFuture.supplyAsync(() -> observation.scoped(supplier)), observation);
    }

    public static <U> CompletableFutureWithSpan<U> supplyAsync(Supplier<U> supplier, UnifiedObservationFactory unifiedObservationFactory, Executor executor) {
        Observation observation = unifiedObservationFactory.getCurrentOrCreateEmptyObservation();
        return CompletableFutureWithSpan.from(CompletableFuture.supplyAsync(() -> observation.scoped(supplier), executor), observation);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, UnifiedObservationFactory unifiedObservationFactory) {
        Observation observation = unifiedObservationFactory.getCurrentOrCreateEmptyObservation();
        return CompletableFutureWithSpan.from(CompletableFuture.runAsync(() -> observation.scoped(runnable)), observation);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, UnifiedObservationFactory unifiedObservationFactory, Executor executor) {
        Observation observation = unifiedObservationFactory.getCurrentOrCreateEmptyObservation();
        return CompletableFutureWithSpan.from(CompletableFuture.runAsync(() -> observation.scoped(runnable), executor), observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenApplyAsync((T t) -> this.observation.scoped(() -> fn.apply(t))), this.observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenApplyAsync((T t) -> this.observation.scoped(() -> fn.apply(t)), executor), this.observation);
    }

    public CompletableFutureWithSpan<Void> thenAcceptAsync(Consumer<? super T> action) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenAcceptAsync(t -> this.observation.scoped(() -> action.accept(t))), this.observation);
    }

    public CompletableFutureWithSpan<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenAcceptAsync(t -> this.observation.scoped(() -> action.accept(t)), executor), this.observation);
    }

    @Override
    public CompletableFutureWithSpan<Void> thenRunAsync(Runnable action) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenRunAsync(() -> this.observation.scoped(action)), this.observation);
    }

    @Override
    public CompletableFutureWithSpan<Void> thenRunAsync(Runnable action, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenRunAsync(() -> this.observation.scoped(action), executor), this.observation);
    }

    @Override
    public <U, V> CompletableFutureWithSpan<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenCombineAsync(other, (T t, U u) -> this.observation.scoped(() -> fn.apply(t, u))), this.observation);
    }

    @Override
    public <U, V> CompletableFutureWithSpan<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenCombineAsync(other, (T t, U u) -> this.observation.scoped(() -> fn.apply(t, u)), executor), this.observation);
    }

    public <U> CompletableFutureWithSpan<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenAcceptBothAsync(other, (t, u) -> this.observation.scoped(() -> action.accept(t, u))), this.observation);
    }

    public <U> CompletableFutureWithSpan<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenAcceptBothAsync(other, (t, u) -> this.observation.scoped(() -> action.accept(t, u)), executor), this.observation);
    }

    public CompletableFutureWithSpan<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return CompletableFutureWithSpan.from(this.completableFuture.runAfterBothAsync((CompletionStage)other, () -> this.observation.scoped(action)), this.observation);
    }

    public CompletableFutureWithSpan<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.runAfterBothAsync((CompletionStage)other, () -> this.observation.scoped(action), executor), this.observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return CompletableFutureWithSpan.from(this.completableFuture.applyToEitherAsync((CompletionStage)other, (T t) -> this.observation.scoped(() -> fn.apply(t))), this.observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.applyToEitherAsync((CompletionStage)other, (T t) -> this.observation.scoped(() -> fn.apply(t)), executor), this.observation);
    }

    public CompletableFutureWithSpan<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return CompletableFutureWithSpan.from(this.completableFuture.acceptEitherAsync((CompletionStage)other, t -> this.observation.scoped(() -> action.accept(t))), this.observation);
    }

    public CompletableFutureWithSpan<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.acceptEitherAsync((CompletionStage)other, t -> this.observation.scoped(() -> action.accept(t)), executor), this.observation);
    }

    public CompletableFutureWithSpan<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return CompletableFutureWithSpan.from(this.completableFuture.runAfterEitherAsync((CompletionStage)other, () -> this.observation.scoped(action)), this.observation);
    }

    public CompletableFutureWithSpan<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.runAfterEitherAsync((CompletionStage)other, () -> this.observation.scoped(action), executor), this.observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenComposeAsync((T t) -> (CompletionStage)this.observation.scoped(() -> (CompletionStage)fn.apply(t))), this.observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.thenComposeAsync((T t) -> (CompletionStage)this.observation.scoped(() -> (CompletionStage)fn.apply(t)), executor), this.observation);
    }

    @Override
    public CompletableFutureWithSpan<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return CompletableFutureWithSpan.from(this.completableFuture.whenCompleteAsync((T t, U throwable) -> this.observation.scoped(() -> action.accept((Object)t, (Throwable)throwable))), this.observation);
    }

    @Override
    public CompletableFutureWithSpan<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.whenCompleteAsync((T t, U throwable) -> this.observation.scoped(() -> action.accept((Object)t, (Throwable)throwable)), executor), this.observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return CompletableFutureWithSpan.from(this.completableFuture.handleAsync((T t, U throwable) -> this.observation.scoped(() -> fn.apply((Object)t, (Throwable)throwable))), this.observation);
    }

    @Override
    public <U> CompletableFutureWithSpan<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return CompletableFutureWithSpan.from(this.completableFuture.handleAsync((T t, U throwable) -> this.observation.scoped(() -> fn.apply((Object)t, (Throwable)throwable)), executor), this.observation);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        return this.completableFuture.completeAsync(() -> this.observation.scoped(supplier), executor);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return this.completableFuture.completeAsync(() -> this.observation.scoped(supplier));
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.completableFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.completableFuture.get(timeout, unit);
    }

    @Override
    public T join() {
        return this.completableFuture.join();
    }

    @Override
    public T getNow(T valueIfAbsent) {
        return this.completableFuture.getNow(valueIfAbsent);
    }

    @Override
    public boolean complete(T value) {
        return this.completableFuture.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.completableFuture.completeExceptionally(ex);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.completableFuture.thenApply(fn);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.completableFuture.thenAccept((Consumer)action);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.completableFuture.thenRun(action);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.completableFuture.thenCombine(other, fn);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.completableFuture.thenAcceptBoth(other, (BiConsumer)action);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.completableFuture.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.completableFuture.applyToEither((CompletionStage)other, fn);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.completableFuture.acceptEither((CompletionStage)other, (Consumer)action);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.completableFuture.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.completableFuture.thenCompose(fn);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.completableFuture.whenComplete(action);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.completableFuture.handle(fn);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.completableFuture.toCompletableFuture();
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.completableFuture.exceptionally(fn);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completableFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.completableFuture.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.completableFuture.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(T value) {
        this.completableFuture.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.completableFuture.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.completableFuture.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.completableFuture.toString();
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return this.completableFuture.newIncompleteFuture();
    }

    @Override
    public Executor defaultExecutor() {
        return this.completableFuture.defaultExecutor();
    }

    @Override
    public CompletableFuture<T> copy() {
        return this.completableFuture.copy();
    }

    @Override
    public CompletionStage<T> minimalCompletionStage() {
        return this.completableFuture.minimalCompletionStage();
    }

    @Override
    public CompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        return this.completableFuture.orTimeout(timeout, unit);
    }

    @Override
    public CompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        return this.completableFuture.completeOnTimeout(value, timeout, unit);
    }
}

