/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.stream;

import io.github.opensabe.common.stream.EnhancedStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnhancedStreamHandler<T>
implements InvocationHandler {
    private static final Method ENHANCED_DISTINCT;
    private static final Map<Method, Method> METHOD_MAP;
    private Stream<T> delegate;

    public EnhancedStreamHandler(Stream<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(ENHANCED_DISTINCT)) {
            return this.distinct((EnhancedStream)proxy, (ToIntFunction)args[0], (BiPredicate)args[1], (BinaryOperator)args[2]);
        }
        if (method.getReturnType() == EnhancedStream.class) {
            Method match = METHOD_MAP.get(method);
            this.delegate = (Stream)match.invoke(this.delegate, args);
            return proxy;
        }
        return method.invoke(this.delegate, args);
    }

    private EnhancedStream<T> distinct(EnhancedStream<T> proxy, ToIntFunction<T> hashCode, BiPredicate<T, T> equals, BinaryOperator<T> merger) {
        this.delegate = this.delegate.collect(Collectors.toMap(t -> new Key<Object>(t, hashCode, equals), Function.identity(), merger, LinkedHashMap::new)).values().stream();
        return proxy;
    }

    static {
        try {
            ENHANCED_DISTINCT = EnhancedStream.class.getMethod("distinct", ToIntFunction.class, BiPredicate.class, BinaryOperator.class);
            METHOD_MAP = Stream.of(EnhancedStream.class.getMethods()).filter(m -> !m.equals(ENHANCED_DISTINCT)).filter(m -> !Modifier.isStatic(m.getModifiers())).collect(Collectors.toUnmodifiableMap(Function.identity(), m -> {
                try {
                    return Stream.class.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new Error(e);
                }
            }));
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static final class Key<E> {
        private final E e;
        private final ToIntFunction<E> hashCode;
        private final BiPredicate<E, E> equals;

        Key(E e, ToIntFunction<E> hashCode, BiPredicate<E, E> equals) {
            this.e = e;
            this.hashCode = hashCode;
            this.equals = equals;
        }

        public int hashCode() {
            return this.hashCode.applyAsInt(this.e);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.equals.test(this.e, that.e);
        }
    }
}

