/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESUtil {
    private static final String SHA1PRNG = "SHA1PRNG";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";

    public static String encrypt(String content, String key) throws Exception {
        return AESUtil.encrypt(content, key, DEFAULT_CIPHER_ALGORITHM);
    }

    public static String encryptNodeJS(String content, String key) throws Exception {
        return AESUtil.encrypt(content, key, "AES/ECB/PKCS5Padding");
    }

    public static String encrypt(String content, String key, String cipherAlgorithm) throws Exception {
        byte[] raw = Base64.decodeBase64((String)key);
        SecretKeySpec sKeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        SecureRandom r = new SecureRandom();
        byte[] ivBytes = new byte[16];
        r.nextBytes(ivBytes);
        cipher.init(1, (Key)sKeySpec, new IvParameterSpec(ivBytes));
        byte[] encrypted = cipher.doFinal(content.getBytes("utf-8"));
        return Base64.encodeBase64String((byte[])AESUtil.byteMerger(ivBytes, encrypted));
    }

    public static byte[] byteMerger(byte[] byte1, byte[] byte2) {
        byte[] byte3 = new byte[byte1.length + byte2.length];
        System.arraycopy(byte1, 0, byte3, 0, byte1.length);
        System.arraycopy(byte2, 0, byte3, byte1.length, byte2.length);
        return byte3;
    }

    public static String decrypt(String base64Encrypted, String key, String cipherAlgorithm) throws Exception {
        byte[] raw = Base64.decodeBase64((String)key);
        SecretKeySpec sKeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        byte[] encrypted = Base64.decodeBase64((String)base64Encrypted);
        byte[] ivByte = new byte[16];
        System.arraycopy(encrypted, 0, ivByte, 0, 16);
        cipher.init(2, (Key)sKeySpec, new IvParameterSpec(ivByte));
        byte[] decrypted = cipher.doFinal(encrypted, 16, encrypted.length - 16);
        return new String(decrypted, "utf-8");
    }

    public static String decryptNodeJS(String base64Encrypted, String key) throws Exception {
        return AESUtil.decrypt(base64Encrypted, key, "AES/ECB/PKCS5Padding");
    }

    public static String decrypt(String base64Encrypted, String key) throws Exception {
        return AESUtil.decrypt(base64Encrypted, key, DEFAULT_CIPHER_ALGORITHM);
    }

    public static byte[] getRawKey(byte[] seed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom sr = null;
        sr = SecureRandom.getInstance(SHA1PRNG);
        sr.setSeed(seed);
        kgen.init(128, sr);
        SecretKey sKey = kgen.generateKey();
        byte[] raw = sKey.getEncoded();
        return raw;
    }
}

