/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.math.BigInteger;

public class Base36 {
    static final char[] ALPHABET;
    static final char[] ALPHABET_WITHOUT_IO;
    static final int[] INVERTED_ALPHABET;
    static final int[] INVERTED_ALPHABET_WIHTOUT_IO;
    static final String INIT_STR = "00000000000000000000000000000000000000000000000000000000000000000000";
    static final String INIT_STR_WITHOUT_IO = "22222222222222222222222222222222222222222222222222222222222222222222";
    static final BigInteger JINZHI;
    static final BigInteger JINZHI_WITHOUT_IO;

    public static String encode(String hexStr) {
        BigInteger bi;
        StringBuffer sb = new StringBuffer();
        BigInteger d = bi = new BigInteger(hexStr, 16);
        BigInteger m = BigInteger.ZERO;
        while (!BigInteger.ZERO.equals(d)) {
            m = d.mod(JINZHI);
            d = d.divide(JINZHI);
            sb.insert(0, ALPHABET[m.intValue()]);
        }
        return sb.toString();
    }

    public static String encodeWithoutIO(String hexStr) {
        BigInteger bi;
        StringBuffer sb = new StringBuffer();
        BigInteger d = bi = new BigInteger(hexStr, 16);
        BigInteger m = BigInteger.ZERO;
        while (!BigInteger.ZERO.equals(d)) {
            m = d.mod(JINZHI_WITHOUT_IO);
            d = d.divide(JINZHI_WITHOUT_IO);
            sb.insert(0, ALPHABET_WITHOUT_IO[m.intValue()]);
        }
        return sb.toString();
    }

    public static String encode(String hexStr, int length) {
        return Base36.encode(hexStr, length, true);
    }

    public static String encode(String hexStr, int length, boolean withoutIO) {
        if (length > 64) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff08length\u4e0d\u80fd\u8d85\u8fc764\uff09:param length = " + length);
        }
        String str = withoutIO ? Base36.encodeWithoutIO(hexStr) : Base36.encode(hexStr);
        if (length > str.length()) {
            str = withoutIO ? INIT_STR_WITHOUT_IO.concat(str) : INIT_STR.concat(str);
            str = str.substring(str.length() - length);
        } else {
            str = str.substring(str.length() - length);
        }
        return str;
    }

    public static String decode(String base36Str) {
        if (base36Str == null || !Base36.isValidBase36Str(base36Str)) {
            throw new NumberFormatException("base36\u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef:" + base36Str);
        }
        base36Str = base36Str.toUpperCase();
        BigInteger bi = BigInteger.ZERO;
        char[] chars = base36Str.toCharArray();
        for (int i = 0; i < base36Str.length(); ++i) {
            char c = chars[i];
            int n = INVERTED_ALPHABET[c];
            bi = bi.multiply(JINZHI).add(new BigInteger("" + n));
        }
        return bi.toString(16);
    }

    public static String decodeWithoutIO(String base31Str) {
        if (base31Str == null || !Base36.isValidBase31Str(base31Str)) {
            throw new NumberFormatException("base36\u9650\u5236\u5b57\u7b26\u4e32\uff08\u53bbIOL10\uff09\u683c\u5f0f\u9519\u8bef:" + base31Str);
        }
        base31Str = base31Str.toUpperCase();
        BigInteger bi = BigInteger.ZERO;
        char[] chars = base31Str.toCharArray();
        for (int i = 0; i < base31Str.length(); ++i) {
            char c = chars[i];
            int n = INVERTED_ALPHABET_WIHTOUT_IO[c];
            bi = bi.multiply(JINZHI_WITHOUT_IO).add(new BigInteger("" + n));
        }
        return bi.toString(16);
    }

    public static boolean isValidBase36Str(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Base36.isValidBase36Char(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBase36Char(char c) {
        if (c < '\u0000' || c >= '\u0080') {
            return false;
        }
        return INVERTED_ALPHABET[c] != -1;
    }

    public static boolean isValidBase31Str(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Base36.isValidBase31Char(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBase31Char(char c) {
        if (c < '\u0000' || c >= '\u0080') {
            return false;
        }
        return INVERTED_ALPHABET_WIHTOUT_IO[c] != -1;
    }

    public static void main(String[] args) {
        String ori = "91a6631029ce0aaad";
        String test = Base36.encode(ori, 20);
        String des = Base36.decode(test);
        System.out.println(ori + " " + test + " " + des);
    }

    static {
        int i;
        ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        ALPHABET_WITHOUT_IO = new char[]{'2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        JINZHI = new BigInteger("36");
        JINZHI_WITHOUT_IO = new BigInteger("31");
        INVERTED_ALPHABET = new int[128];
        for (i = 0; i < 128; ++i) {
            Base36.INVERTED_ALPHABET[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base36.INVERTED_ALPHABET[i] = i - 65 + 10;
        }
        for (i = 48; i <= 57; ++i) {
            Base36.INVERTED_ALPHABET[i] = i - 48;
        }
        INVERTED_ALPHABET_WIHTOUT_IO = new int[128];
        for (i = 0; i < 128; ++i) {
            Base36.INVERTED_ALPHABET_WIHTOUT_IO[i] = -1;
        }
        for (i = 0; i < ALPHABET_WITHOUT_IO.length; ++i) {
            Base36.INVERTED_ALPHABET_WIHTOUT_IO[Base36.ALPHABET_WITHOUT_IO[i]] = i;
        }
    }
}

