/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Base64 {
    private static final byte[] ENCODING_TABLE;
    private static final byte[] DECODING_TABLE;

    public static String encodeS(byte[] data) {
        return new String(Base64.encode(data));
    }

    public static byte[] encode(byte[] data) {
        int modulus = data.length % 3;
        byte[] bytes = modulus == 0 ? new byte[4 * data.length / 3] : new byte[4 * (data.length / 3 + 1)];
        int dataLength = data.length - modulus;
        int i = 0;
        int j = 0;
        while (i < dataLength) {
            int a1 = data[i] & 0xFF;
            int a2 = data[i + 1] & 0xFF;
            int a3 = data[i + 2] & 0xFF;
            bytes[j] = ENCODING_TABLE[a1 >>> 2 & 0x3F];
            bytes[j + 1] = ENCODING_TABLE[(a1 << 4 | a2 >>> 4) & 0x3F];
            bytes[j + 2] = ENCODING_TABLE[(a2 << 2 | a3 >>> 6) & 0x3F];
            bytes[j + 3] = ENCODING_TABLE[a3 & 0x3F];
            i += 3;
            j += 4;
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                bytes[bytes.length - 4] = ENCODING_TABLE[b1];
                bytes[bytes.length - 3] = ENCODING_TABLE[b2];
                bytes[bytes.length - 2] = 61;
                bytes[bytes.length - 1] = 61;
                break;
            }
            case 2: {
                int d1 = data[data.length - 2] & 0xFF;
                int d2 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                bytes[bytes.length - 4] = ENCODING_TABLE[b1];
                bytes[bytes.length - 3] = ENCODING_TABLE[b2];
                bytes[bytes.length - 2] = ENCODING_TABLE[b3];
                bytes[bytes.length - 1] = 61;
            }
        }
        return bytes;
    }

    public static byte[] decode(byte[] data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = (data = Base64.discardNonBase64Bytes(data))[data.length - 2] == 61 ? new byte[(data.length / 4 - 1) * 3 + 1] : (data[data.length - 1] == 61 ? new byte[(data.length / 4 - 1) * 3 + 2] : new byte[data.length / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length - 4) {
            b1 = DECODING_TABLE[data[i]];
            b2 = DECODING_TABLE[data[i + 1]];
            b3 = DECODING_TABLE[data[i + 2]];
            b4 = DECODING_TABLE[data[i + 3]];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data[data.length - 2] == 61) {
            b1 = DECODING_TABLE[data[data.length - 4]];
            b2 = DECODING_TABLE[data[data.length - 3]];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data[data.length - 1] == 61) {
            b1 = DECODING_TABLE[data[data.length - 4]];
            b2 = DECODING_TABLE[data[data.length - 3]];
            b3 = DECODING_TABLE[data[data.length - 2]];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = DECODING_TABLE[data[data.length - 4]];
            b2 = DECODING_TABLE[data[data.length - 3]];
            b3 = DECODING_TABLE[data[data.length - 2]];
            b4 = DECODING_TABLE[data[data.length - 1]];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    public static byte[] decode(String data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = (data = Base64.discardNonBase64Chars(data)).charAt(data.length() - 2) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 1] : (data.charAt(data.length() - 1) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 2] : new byte[data.length() / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length() - 4) {
            b1 = DECODING_TABLE[data.charAt(i)];
            b2 = DECODING_TABLE[data.charAt(i + 1)];
            b3 = DECODING_TABLE[data.charAt(i + 2)];
            b4 = DECODING_TABLE[data.charAt(i + 3)];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data.charAt(data.length() - 2) == '=') {
            b1 = DECODING_TABLE[data.charAt(data.length() - 4)];
            b2 = DECODING_TABLE[data.charAt(data.length() - 3)];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data.charAt(data.length() - 1) == '=') {
            b1 = DECODING_TABLE[data.charAt(data.length() - 4)];
            b2 = DECODING_TABLE[data.charAt(data.length() - 3)];
            b3 = DECODING_TABLE[data.charAt(data.length() - 2)];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = DECODING_TABLE[data.charAt(data.length() - 4)];
            b2 = DECODING_TABLE[data.charAt(data.length() - 3)];
            b3 = DECODING_TABLE[data.charAt(data.length() - 2)];
            b4 = DECODING_TABLE[data.charAt(data.length() - 1)];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    private static byte[] discardNonBase64Bytes(byte[] data) {
        byte[] temp = new byte[data.length];
        int bytesCopied = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Base64.isValidBase64Byte(data[i])) continue;
            temp[bytesCopied++] = data[i];
        }
        byte[] newData = new byte[bytesCopied];
        System.arraycopy(temp, 0, newData, 0, bytesCopied);
        return newData;
    }

    private static String discardNonBase64Chars(String data) {
        StringBuffer sb = new StringBuffer();
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            if (!Base64.isValidBase64Byte((byte)data.charAt(i))) continue;
            sb.append(data.charAt(i));
        }
        return sb.toString();
    }

    private static boolean isValidBase64Byte(byte b) {
        if (b == 61) {
            return true;
        }
        if (b < 0 || b >= 128) {
            return false;
        }
        return DECODING_TABLE[b] != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressBytes(byte[] input) {
        int cachesize = 1024;
        Deflater compresser = new Deflater();
        compresser.reset();
        compresser.setInput(input);
        compresser.finish();
        byte[] output = new byte[]{};
        ByteArrayOutputStream o = new ByteArrayOutputStream(input.length);
        try {
            byte[] buf = new byte[cachesize];
            while (!compresser.finished()) {
                int got = compresser.deflate(buf);
                o.write(buf, 0, got);
            }
            output = o.toByteArray();
        }
        finally {
            try {
                o.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompressBytes(byte[] input) {
        int cachesize = 1024;
        Inflater decompresser = new Inflater();
        byte[] output = new byte[]{};
        decompresser.reset();
        decompresser.setInput(input);
        ByteArrayOutputStream o = new ByteArrayOutputStream(input.length);
        try {
            byte[] buf = new byte[cachesize];
            while (!decompresser.finished()) {
                int got = decompresser.inflate(buf);
                o.write(buf, 0, got);
            }
            output = o.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                o.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    static {
        int i;
        ENCODING_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        DECODING_TABLE = new byte[128];
        for (i = 0; i < 128; ++i) {
            Base64.DECODING_TABLE[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.DECODING_TABLE[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.DECODING_TABLE[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.DECODING_TABLE[i] = (byte)(i - 48 + 52);
        }
        Base64.DECODING_TABLE[43] = 62;
        Base64.DECODING_TABLE[47] = 63;
    }
}

