/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.github.opensabe.common.bytecode.BeanCopier;
import io.github.opensabe.common.bytecode.ByteBuddyBeanCopier;
import io.github.opensabe.mapstruct.core.MapperRepository;
import java.util.Map;

public class BeanUtils {
    private static final Cache<String, BeanCopier<?, ?>> CACHE = Caffeine.newBuilder().build();
    private static final MapperRepository MAPPER_REPOSITORY = MapperRepository.getInstance();

    public static void copyProperties(Object source, Object target) {
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        BeanCopier beanCopier = (BeanCopier)CACHE.get((Object)(sourceClass.getName() + " to " + targetClass.getName()), k -> ByteBuddyBeanCopier.create(source.getClass(), target.getClass()));
        beanCopier.copy(source, target);
    }

    public static <S, T> T transform(S source, Class<T> target) {
        return (T)MAPPER_REPOSITORY.getMapper(source.getClass(), target).map(source);
    }

    public static <T> T fromMap(Map<String, Object> map, Class<T> target) {
        return (T)MAPPER_REPOSITORY.getMapMapper(target).fromMap(map);
    }
}

