/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_YYYYMM = "yyyy-MM";
    public static final String DATE_FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String DATE_FORMAT_YYYYMMDDHH = "yyyyMMddHH";
    public static final String DATE_FORMAT_YYYYMMDD_HHMM = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_YYYYMMDD_HHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_YYYYMMDD_HHMMSS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMAT_HH = "HH";
    public static final String HHMMSS_SSS = "HH:mm:ss.SSS";
    public static final String DATE_FORMAT_MMDD_HHMM = "MM-dd HH:mm";
    public static final int FMT_DATE_YYYY = 0;
    public static final int FMT_DATE_YYYYMMDD = 1;
    public static final int FMT_DATE_YYYYMMDD_HHMMSS = 2;
    public static final int FMT_DATE_HHMMSS = 3;
    public static final int FMT_DATE_HHMM = 4;
    public static final int FMT_DATE_SPECIAL = 5;
    public static final int FMT_DATE_MMDD = 6;
    public static final int FMT_DATE_YYYYMMDDHHMM = 7;
    public static final int FMT_DATE_MMDD_HHMM = 8;
    public static final int FMT_DATE_MMMDDD = 9;
    public static final int FMT_DATE_YYYYMMDDHHMM_NEW = 10;
    public static final int FMT_DATE_YYYYMMDDHHMMSS = 12;
    public static final int FMT_DATE_YYMMDD = 13;
    public static final int FMT_DATE_YYMMDDHH = 14;
    public static final int FMT_DATE_MMDD_HHMM_CH = 15;
    public static final int FMT_DATE_MMDD_HHMMSS = 18;
    public static final int FMT_DATE_YYYYMMDD_DOT = 19;
    public static final int FMT_DATE_MMDD_HH_CH = 20;
    public static final int GET_TIME_OF_YEAR = 100;
    public static final int GET_TIME_OF_MONTH = 200;
    public static final int GET_TIME_OF_DAY = 300;
    public static final int GET_TIME_IF_HOUR = 400;
    public static final int GET_TIME_OF_MINUTE = 500;
    public static final int GET_TIME_OF_SECOND = 600;
    public static String[] formatTab;
    private static Log log;

    public static String getPartTime(Date date, int flag) {
        if (date == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int result = 0;
        switch (flag) {
            case 100: {
                result = cal.get(1);
                break;
            }
            case 200: {
                result = cal.get(2) + 1;
                break;
            }
            case 300: {
                result = cal.get(5);
                break;
            }
            case 400: {
                result = cal.get(11);
                break;
            }
            case 500: {
                result = cal.get(12);
                break;
            }
            case 600: {
                result = cal.get(13);
                break;
            }
            default: {
                result = cal.get(1);
            }
        }
        return String.valueOf(result);
    }

    public static String formatNowTime(int nFmt) {
        Calendar cal = Calendar.getInstance();
        return DateUtil.formatDate(cal.getTime(), nFmt);
    }

    public static String formatDate(Date date, int nFmt) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat fmtDate = new SimpleDateFormat();
        switch (nFmt) {
            default: {
                fmtDate.applyLocalizedPattern("yyyy");
                break;
            }
            case 1: {
                fmtDate.applyPattern(DEFAULT_DATE_FORMAT);
                break;
            }
            case 2: {
                fmtDate.applyPattern(DATE_FORMAT_YYYYMMDD_HHMMSS);
                break;
            }
            case 4: {
                fmtDate.applyPattern("HH:mm");
                break;
            }
            case 3: {
                fmtDate.applyPattern("HH:mm:ss");
                break;
            }
            case 5: {
                fmtDate.applyPattern(DATE_FORMAT_YYYYMMDD);
                break;
            }
            case 6: {
                fmtDate.applyPattern("MM-dd");
                break;
            }
            case 7: {
                fmtDate.applyPattern(DATE_FORMAT_YYYYMMDD_HHMM);
                break;
            }
            case 8: {
                fmtDate.applyPattern(DATE_FORMAT_MMDD_HHMM);
                break;
            }
            case 9: {
                fmtDate.applyPattern("MM\u6708dd\u65e5");
                break;
            }
            case 10: {
                fmtDate.applyPattern("yyyyMMddHHmm");
                break;
            }
            case 12: {
                fmtDate.applyPattern(DATE_FORMAT_YYYYMMDDHHMMSS);
                break;
            }
            case 13: {
                fmtDate.applyPattern("yyMMdd");
                break;
            }
            case 14: {
                fmtDate.applyPattern(DATE_FORMAT_YYYYMMDDHH);
                break;
            }
            case 18: {
                fmtDate.applyPattern("MM-dd HH:mm:ss");
                break;
            }
            case 19: {
                fmtDate.applyPattern("yyyy.MM.dd");
            }
        }
        return fmtDate.format(date);
    }

    public static Date transferDateFormat(Date date, String format) {
        String dateString = DateUtil.formatDate(date, format);
        SimpleDateFormat fmtDate = new SimpleDateFormat(format);
        try {
            return fmtDate.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return date;
        }
    }

    public static Date parseUtilDate(String strDate, int nFmtDate) {
        if (strDate == null || strDate.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat fmtDate = null;
        switch (nFmtDate) {
            default: {
                fmtDate = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
                break;
            }
            case 2: {
                fmtDate = new SimpleDateFormat(DATE_FORMAT_YYYYMMDD_HHMMSS);
                break;
            }
            case 4: {
                fmtDate = new SimpleDateFormat("HH:mm");
                break;
            }
            case 3: {
                fmtDate = new SimpleDateFormat("HH:mm:ss");
                break;
            }
            case 12: {
                fmtDate = new SimpleDateFormat(DATE_FORMAT_YYYYMMDDHHMMSS);
                break;
            }
            case 7: {
                fmtDate = new SimpleDateFormat("yyyyMMddHHmm");
            }
        }
        try {
            return fmtDate.parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp getToday(Timestamp ts) {
        try {
            String dateStr = DateUtil.formatDate((Date)ts, 1);
            SimpleDateFormat fmtDate = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
            return new Timestamp(fmtDate.parse(dateStr).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getIntervalDateFormat(String date2Get, String sourceFormat, int days) {
        try {
            SimpleDateFormat sorceFmt = new SimpleDateFormat(sourceFormat);
            Date date = new Date(sorceFmt.parse(date2Get).getTime() + (long)days * 86400000L);
            return date;
        }
        catch (ParseException e) {
            log.warn((Object)("invalid date2Get :" + date2Get));
            return null;
        }
    }

    public static boolean isDayAfterTomorrow(Date start) {
        Timestamp today = DateUtil.getBeginOfToday();
        Date dayAfterTomorrow = DateUtil.getIntervalDate(today, 2L);
        Date dayAfterTomorrowAddOne = DateUtil.getIntervalDate(today, 3L);
        return start.getTime() >= dayAfterTomorrow.getTime() && start.getTime() < dayAfterTomorrowAddOne.getTime();
    }

    public static boolean isTomorrow(Date start) {
        Timestamp today = DateUtil.getBeginOfToday();
        Date tomorrow = DateUtil.getIntervalDate(today, 1L);
        Date dayAfterTomorrow = DateUtil.getIntervalDate(today, 2L);
        return start.getTime() >= tomorrow.getTime() && start.getTime() < dayAfterTomorrow.getTime();
    }

    public static String getSpecialDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_MMDD_HHMM);
        StringBuffer sb = new StringBuffer();
        if (DateUtil.isToday(date)) {
            sb.append("today");
            sb.append(df.format(date));
        } else if (DateUtil.isTomorrow(date)) {
            sb.append("tomorrow");
            sb.append(df.format(date));
        } else {
            if (!DateUtil.isDayAfterTomorrow(date)) {
                df = new SimpleDateFormat("yyyy-MM-dd(E)HH:mm");
                sb.append(df.format(date));
                return sb.toString();
            }
            sb.append("tomorrow after tomorrow");
            sb.append(df.format(date));
        }
        return sb.toString();
    }

    public static String formatDate(Date target) {
        return DateUtil.formatDate(target, DEFAULT_DATE_FORMAT);
    }

    public static Date getIntervalDate(Date origin, long intervals) {
        return new Date(origin.getTime() + intervals * 86400000L);
    }

    public static Date getIntervalSeconds(Date origin, long seconds) {
        return new Date(origin.getTime() + seconds * 1000L);
    }

    public static Timestamp getIntervalTimestamp(Timestamp ts, int minutes) {
        if (minutes == 0) {
            return ts;
        }
        return new Timestamp(ts.getTime() + (long)(minutes * 60) * 1000L);
    }

    public static Timestamp getIntervalTimestampBySeconds(Timestamp ts, long seconds) {
        return new Timestamp(ts.getTime() + seconds * 1000L);
    }

    public static Timestamp getIntervalTimestampByDays(Timestamp ts, long days) {
        return DateUtil.getIntervalTimestampBySeconds(ts, days * 86400L);
    }

    public static Date transToQueryDate(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(date.getYear() + 1900, date.getMonth(), date.getDate(), 0, 0, 0);
        return c.getTime();
    }

    public static long getDiffMinutes(Timestamp from, Timestamp to) {
        return (to.getTime() - from.getTime()) / 60000L;
    }

    public static int getDiffMonth(Timestamp from, Timestamp to) {
        return (int)(DateUtil.getDiffMinutes(from, to) / 43200L);
    }

    public static int getDiffYear(Timestamp from, Timestamp to) {
        return (int)(DateUtil.getDiffMinutes(from, to) / 518400L);
    }

    public static long getDiffSeconds(Timestamp from, Timestamp to) {
        return (to.getTime() - from.getTime()) / 1000L;
    }

    public static long getDiffMsecs(Timestamp from, Timestamp to) {
        return to.getTime() - from.getTime();
    }

    public static int getDiffDays(Timestamp from, Timestamp to) {
        return (int)(DateUtil.getDiffMinutes(from, to) / 1440L);
    }

    public static boolean isBetween(Date date, Date start, Date end) {
        boolean isBetween = date.compareTo(start) >= 0 && date.getTime() <= end.getTime() + 999L;
        return isBetween;
    }

    public static boolean isToday(Date start) {
        long beginOfToday = DateUtil.getBeginOfToday().getTime();
        long endOfToday = DateUtil.getEndOfToday().getTime();
        boolean result = start.getTime() >= beginOfToday && start.getTime() <= endOfToday;
        return result;
    }

    public static Timestamp getBeginOfToday() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat form = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        String dateStr = form.format(cal.getTime()) + " 00:00:00";
        Date date = null;
        try {
            date = form.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp getBeginOfOneDay(Timestamp times) {
        SimpleDateFormat form = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        String dateStr = form.format(times.getTime()) + " 00:00:00";
        Date date = null;
        try {
            date = form.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp getBeginOfYesterday() {
        return DateUtil.getIntervalTimestamp(DateUtil.getBeginOfToday(), -1440);
    }

    public static Timestamp getBeginOfCurrentMonth() {
        String firstDayOfCurrentMonth = DateUtil.getCurrentMonth() + "01";
        return DateUtil.formatString(firstDayOfCurrentMonth, 5);
    }

    public static Timestamp getBeginOfLastMonth() {
        String firstDayOfCurrentMonth = DateUtil.getLastMonth() + "01";
        return DateUtil.formatString(firstDayOfCurrentMonth, 5);
    }

    public static Timestamp getEndOfToday() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat form = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        String dateStr = form.format(cal.getTime()) + " 23:59:59";
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YYYYMMDD_HHMMSS);
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static boolean isYesterday(Date start) {
        Timestamp today = DateUtil.getBeginOfToday();
        Date yesterday = DateUtil.getIntervalDate(today, -1L);
        return start.getTime() >= yesterday.getTime() && start.getTime() < ((Date)today).getTime();
    }

    public static String formatDate(Date target, String format) {
        if (target == null) {
            return "";
        }
        return new SimpleDateFormat(format).format(target);
    }

    public static String formatStr2Str(String source, String srcFormat, String destFormat) throws Exception {
        if (source == null) {
            return "";
        }
        SimpleDateFormat df1 = new SimpleDateFormat(srcFormat);
        SimpleDateFormat df2 = new SimpleDateFormat(destFormat);
        return df2.format(df1.parse(source));
    }

    public static String formatTime(Timestamp target) {
        if (target == null) {
            return "";
        }
        return new SimpleDateFormat(DATE_FORMAT_YYYYMMDD_HHMMSS).format(target);
    }

    public static String formatTime(Timestamp target, String format) {
        if (target == null) {
            return "";
        }
        return new SimpleDateFormat(format).format(target);
    }

    public static Timestamp formatString(String target, String format) {
        if (StringUtils.isBlank((CharSequence)target)) {
            return null;
        }
        try {
            Date date = new SimpleDateFormat(format).parse(target);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Timestamp formatString(String target, int format) {
        if (StringUtils.isBlank((CharSequence)target)) {
            return null;
        }
        try {
            Date date = new SimpleDateFormat(formatTab[format]).parse(target);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean compareDate(Date firstDate, Date nextDate) {
        return firstDate.before(nextDate);
    }

    public static Timestamp formatToTimestamp(String dateStr, String format) {
        try {
            SimpleDateFormat sorceFmt = new SimpleDateFormat(format);
            return new Timestamp(sorceFmt.parse(dateStr).getTime());
        }
        catch (ParseException e) {
            log.warn((Object)("invalid date2Get :" + dateStr));
            return null;
        }
    }

    public static Date getIntervalMonth(Date date, int i) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + i);
        return calendar.getTime();
    }

    public static String getIntervalDateStr(long time, long i, String format) {
        return DateUtil.formatTime(new Timestamp(time + 86400000L * i), format);
    }

    public static Date formatToDate(String date, String format) {
        try {
            if (StringUtils.isBlank((CharSequence)date)) {
                return null;
            }
            SimpleDateFormat sorceFmt = new SimpleDateFormat(format);
            return new Date(sorceFmt.parse(date).getTime());
        }
        catch (ParseException e) {
            log.warn((Object)("invalid date :" + date));
            return null;
        }
    }

    public static String getCurrentMonth() {
        return DateUtil.getCurrentMonth("yyyyMM");
    }

    public static String getCurrentDay() {
        return DateUtil.getCurrentDay(DATE_FORMAT_YYYYMMDD);
    }

    public static String getCurrentMonth(String format) {
        return DateUtil.formatDate(new Date(), format);
    }

    public static String getCurrentDay(String format) {
        return DateUtil.formatDate(new Date(), format);
    }

    public static String getMonth(Timestamp time) {
        return new SimpleDateFormat("yyyyMM").format(time);
    }

    public static String getDate(Timestamp time) {
        return new SimpleDateFormat(DATE_FORMAT_YYYYMMDD).format(time);
    }

    public static String getDate(Timestamp time, String format) {
        return new SimpleDateFormat(format).format(time);
    }

    public static String getCurrentDate() {
        return DateUtil.formatTime(DateUtil.getCurrentTimestamp(), DATE_FORMAT_YYYYMMDD_HHMMSS);
    }

    public static String getHour(Timestamp time) {
        return new SimpleDateFormat(DATE_FORMAT_HH).format(time);
    }

    public static String getLastMonth() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        return new SimpleDateFormat("yyyyMM").format(new Timestamp(c.getTimeInMillis()));
    }

    public static String getNextMonth() {
        Calendar c = Calendar.getInstance();
        c.add(2, 1);
        return new SimpleDateFormat("yyyyMM").format(new Timestamp(c.getTimeInMillis()));
    }

    public static String getNextMonth(Timestamp time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time.getTime());
        c.add(2, 1);
        return new SimpleDateFormat("yyyyMM").format(new Timestamp(c.getTimeInMillis()));
    }

    public static Timestamp convertMonthStr2Time(String sourceMonthStr) {
        try {
            SimpleDateFormat fmtDate = new SimpleDateFormat("yyyyMM");
            return new Timestamp(fmtDate.parse(sourceMonthStr).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getLastMonth(Timestamp time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time.getTime());
        c.add(2, -1);
        return new SimpleDateFormat("yyyyMM").format(new Timestamp(c.getTimeInMillis()));
    }

    private static Map<Integer, String> initWeekMap() {
        HashMap<Integer, String> weekMap = new HashMap<Integer, String>();
        weekMap.put(1, "Sunday");
        weekMap.put(2, "Monday");
        weekMap.put(3, "Tuesday");
        weekMap.put(4, "Wednesday");
        weekMap.put(5, "Thursday");
        weekMap.put(6, "Friday");
        weekMap.put(7, "Saturday");
        return weekMap;
    }

    public static String getMonday(Timestamp current) {
        Calendar c = Calendar.getInstance();
        c.setTime(current);
        c.set(7, 2);
        return new SimpleDateFormat(DATE_FORMAT_YYYYMMDD).format(c.getTime());
    }

    public static int getWeekth(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        int dayOfWeek = c1.get(7);
        Timestamp t1 = new Timestamp(d1.getTime());
        Timestamp t2 = new Timestamp(d2.getTime());
        int diffdays = DateUtil.getDiffDays(t1, t2);
        System.err.println("dayOfWeek:" + dayOfWeek + ",diffdays\uff1a" + diffdays);
        if (diffdays <= 8 - dayOfWeek) {
            return 1;
        }
        int result = (diffdays + dayOfWeek - 7) / 7;
        return result + 2;
    }

    public static String getWeek(Date date) {
        return new SimpleDateFormat("E").format(date);
    }

    public static int getWeekOfYearOfCurrentDay() {
        return DateUtil.getWeekOfYear(new Date());
    }

    public static int getWeekOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static String convertToDateString(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString) || dateString.length() != 6) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("20");
        buffer.append(dateString.subSequence(0, 2));
        buffer.append("-");
        buffer.append(dateString.subSequence(2, 4));
        buffer.append("-");
        buffer.append(dateString.subSequence(4, 6));
        return buffer.toString();
    }

    public static Timestamp getMMTimestampOfCurr() {
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        cal.set(13, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static String getTodayTomorrowAndAfterTomorrow(Timestamp time) {
        if (time == null) {
            return null;
        }
        Timestamp current = DateUtil.getCurrentTimestamp();
        Timestamp tomorrow = DateUtil.getIntervalTimestampByDays(current, 1L);
        Timestamp afterTomorrow = DateUtil.getIntervalTimestampByDays(current, 2L);
        try {
            if (DateUtil.formatTime(time, DATE_FORMAT_YYYYMMDD).equals(DateUtil.formatTime(current, DATE_FORMAT_YYYYMMDD))) {
                return "today";
            }
            if (DateUtil.formatTime(time, DATE_FORMAT_YYYYMMDD).equals(DateUtil.formatTime(tomorrow, DATE_FORMAT_YYYYMMDD))) {
                return "tomorrow";
            }
            if (DateUtil.formatTime(time, DATE_FORMAT_YYYYMMDD).equals(DateUtil.formatTime(afterTomorrow, DATE_FORMAT_YYYYMMDD))) {
                return "tomorrow after tomorrow";
            }
        }
        catch (Throwable e) {
            log.error((Object)("getTodayTomorrowAndAfterTomorrow error, time\uff1a" + String.valueOf(time)), e);
        }
        return null;
    }

    public static String getTodayOrYesterday(Timestamp time) {
        if (time == null) {
            return null;
        }
        Timestamp current = DateUtil.getCurrentTimestamp();
        Timestamp yesterday = DateUtil.getIntervalTimestampByDays(current, -1L);
        try {
            if (DateUtil.formatTime(time, DATE_FORMAT_YYYYMMDD).equals(DateUtil.formatTime(current, DATE_FORMAT_YYYYMMDD))) {
                return "today";
            }
            if (DateUtil.formatTime(time, DATE_FORMAT_YYYYMMDD).equals(DateUtil.formatTime(yesterday, DATE_FORMAT_YYYYMMDD))) {
                return "yesterday";
            }
        }
        catch (Throwable e) {
            log.error((Object)("getTodayOrYesterday error, time\uff1a" + String.valueOf(time)), e);
        }
        return null;
    }

    public static String getCouponDisplayExpireDate(Timestamp expireTime, boolean needModify) {
        Timestamp tmp = DateUtil.getCurrentTimestamp();
        tmp.setTime(System.currentTimeMillis() + 630720000000L);
        if (tmp.before(expireTime)) {
            return "forever valid";
        }
        Timestamp dispExpireTime = DateUtil.getIntervalTimestampBySeconds(expireTime, -1L);
        String dispDate = DateUtil.formatTime(dispExpireTime, DEFAULT_DATE_FORMAT);
        if (needModify) {
            return "(" + dispDate + ") expires";
        }
        return dispDate;
    }

    public static Timestamp getNowDayTimeStamp(int hour, int second, int minute, int millisecond) {
        Calendar cal = Calendar.getInstance();
        cal.set(10, hour);
        cal.set(13, second);
        cal.set(12, minute);
        cal.set(14, millisecond);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getEndOfOneDay(Timestamp times) {
        SimpleDateFormat form = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        String dateStr = form.format(times.getTime()) + " 23:59:59";
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YYYYMMDD_HHMMSS);
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp getNowDayTimeStamps(int hour, int second, int minute, int millisecond) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, hour);
        cal.set(13, second);
        cal.set(12, minute);
        cal.set(14, millisecond);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static boolean ifInCriticalTime(Date time, int beforeMonth, int afterMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        int currentDay = c.get(5);
        Calendar begin = Calendar.getInstance();
        begin.setTime(time);
        if (currentDay != 1) {
            begin.add(2, 1);
            begin.set(5, 1);
        }
        begin.set(11, 0);
        begin.set(12, 0);
        begin.set(13, 0);
        begin.set(14, 0);
        Calendar end = (Calendar)begin.clone();
        begin.add(12, -beforeMonth);
        end.add(12, afterMonth);
        return time.getTime() >= begin.getTimeInMillis() && time.getTime() <= end.getTimeInMillis();
    }

    public static boolean ifInterTimeRange(String start, String end) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_YYYYMMDD_HHMMSS);
        try {
            Date startTime = sdf.parse(start);
            Date endTime = sdf.parse(end);
            Date nowTime = new Date();
            boolean tag = nowTime.after(startTime) && nowTime.before(endTime);
            return tag;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String transferTimeStampToStr(Timestamp timestamp, String format) {
        String tsStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            tsStr = sdf.format(timestamp);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return tsStr;
    }

    public static boolean isSameDate(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    public static long changeTimeZoneStringToStamp(String dateStr) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return System.currentTimeMillis();
        }
        String[] arr = dateStr.split(" ");
        String time = arr[0] + " " + arr[1];
        String timeZone = arr[2];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_YYYYMMDD_HHMMSS);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        return simpleDateFormat.parse(time).getTime();
    }

    static {
        log = LogFactory.getLog(DateUtil.class);
        formatTab = new String[21];
        DateUtil.formatTab[0] = "yyyy";
        DateUtil.formatTab[1] = DEFAULT_DATE_FORMAT;
        DateUtil.formatTab[2] = DATE_FORMAT_YYYYMMDD_HHMMSS;
        DateUtil.formatTab[3] = "HH:mm:ss";
        DateUtil.formatTab[4] = "HH:mm";
        DateUtil.formatTab[5] = DATE_FORMAT_YYYYMMDD;
        DateUtil.formatTab[6] = "MM-dd";
        DateUtil.formatTab[7] = DATE_FORMAT_YYYYMMDD_HHMM;
        DateUtil.formatTab[8] = DATE_FORMAT_MMDD_HHMM;
        DateUtil.formatTab[10] = "yyyyMMddHHmm";
        DateUtil.formatTab[12] = DATE_FORMAT_YYYYMMDDHHMMSS;
        DateUtil.formatTab[13] = "yyMMdd";
        DateUtil.formatTab[14] = DATE_FORMAT_YYYYMMDDHH;
    }
}

