/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import cn.hutool.core.util.ZipUtil;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.Base64;
import org.apache.commons.lang.StringUtils;

public class GzipUtil {
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    public static String zipThenBase64Enc(String source) {
        byte[] bytes = ZipUtil.gzip((String)source, (String)DEFAULT_CHARSET.name());
        return new String(Base64.getEncoder().encode(bytes), DEFAULT_CHARSET);
    }

    public static String base64DecThenUnzip(String source) {
        byte[] decode = Base64.getDecoder().decode(source);
        byte[] bytes = ZipUtil.unGzip((byte[])decode);
        return new String(bytes, DEFAULT_CHARSET);
    }

    public static String unzipped(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            if ("null".equalsIgnoreCase(value)) {
                return null;
            }
            if (value.charAt(0) != '{' && value.charAt(0) != '[') {
                value = GzipUtil.base64DecThenUnzip(value);
            }
        }
        return value;
    }
}

