/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;

public class IpUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(IpUtil.class);
    public static final String DEFAULT_IP = "0.0.0.0";
    private static final InetAddressValidator VALIDATOR = InetAddressValidator.getInstance();

    public static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                log.trace((Object)("Testing interface: " + ifc.getDisplayName()));
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    log.trace((Object)("Found non-loopback interface: " + ifc.getDisplayName()));
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)"Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Unable to retrieve localhost");
            return null;
        }
    }

    private static boolean isValidIp(String ip) {
        return !StringUtils.isBlank((CharSequence)ip) && !StringUtils.isEmpty((CharSequence)ip) && !StringUtils.equalsIgnoreCase((CharSequence)"unknown", (CharSequence)ip) && !StringUtils.equalsIgnoreCase((CharSequence)"null", (CharSequence)ip);
    }

    public static String getIpFromHeader(HttpServletRequest request) {
        try {
            List<String> ipSources = IpUtil.collectIpSources(request);
            String result = IpUtil.findFirstNonInternalIp(ipSources);
            return result != null ? result : DEFAULT_IP;
        }
        catch (Throwable e) {
            log.error("getting user ip from header error: {}", (Object)e.getMessage(), (Object)e);
            return DEFAULT_IP;
        }
    }

    public static String getIpFromHeader(HttpHeaders headers) {
        try {
            List<String> ipSources = IpUtil.collectIpSources(headers);
            String result = IpUtil.findFirstNonInternalIp(ipSources);
            return result;
        }
        catch (Throwable e) {
            log.error("getting user ip from headers error: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private static List<String> collectIpSources(HttpServletRequest request) {
        ArrayList<String> ipSources = new ArrayList<String>();
        IpUtil.addIpSource(ipSources, request.getHeader("x-forwarded-for"));
        IpUtil.addIpSource(ipSources, request.getHeader("Proxy-Client-IP"));
        IpUtil.addIpSource(ipSources, request.getHeader("WL-Proxy-Client-IP"));
        IpUtil.addIpSource(ipSources, request.getHeader("HTTP_CLIENT_IP"));
        IpUtil.addIpSource(ipSources, request.getHeader("HTTP_X_FORWARDED_FOR"));
        IpUtil.addIpSource(ipSources, request.getHeader("X-Real-IP"));
        IpUtil.addIpSource(ipSources, request.getRemoteAddr());
        return ipSources;
    }

    private static List<String> collectIpSources(HttpHeaders headers) {
        ArrayList<String> ipSources = new ArrayList<String>();
        Optional.ofNullable(headers.get((Object)"x-forwarded-for")).ifPresent(h -> h.forEach(ip -> IpUtil.addIpSource(ipSources, ip)));
        Optional.ofNullable(headers.get((Object)"Proxy-Client-IP")).ifPresent(h -> h.forEach(ip -> IpUtil.addIpSource(ipSources, ip)));
        Optional.ofNullable(headers.get((Object)"WL-Proxy-Client-IP")).ifPresent(h -> h.forEach(ip -> IpUtil.addIpSource(ipSources, ip)));
        Optional.ofNullable(headers.get((Object)"HTTP_CLIENT_IP")).ifPresent(h -> h.forEach(ip -> IpUtil.addIpSource(ipSources, ip)));
        Optional.ofNullable(headers.get((Object)"HTTP_X_FORWARDED_FOR")).ifPresent(h -> h.forEach(ip -> IpUtil.addIpSource(ipSources, ip)));
        Optional.ofNullable(headers.get((Object)"X-Real-IP")).ifPresent(h -> h.forEach(ip -> IpUtil.addIpSource(ipSources, ip)));
        return ipSources;
    }

    private static void addIpSource(List<String> ipSources, String ip) {
        String[] ips;
        for (String singleIp : ips = IpUtil.parseIpString(ip)) {
            if (!IpUtil.isValidIp(singleIp)) continue;
            ipSources.add(singleIp);
        }
    }

    private static String[] parseIpString(String ips) {
        if (!IpUtil.isValidIp(ips)) {
            return new String[0];
        }
        return (String[])Stream.of(ips.split("\\,")).map(String::trim).filter(ip -> IpUtil.isValidIp(ip) && !DEFAULT_IP.equals(ip)).toArray(String[]::new);
    }

    private static String findFirstNonInternalIp(List<String> ipSources) {
        if (CollectionUtils.isEmpty(ipSources)) {
            return DEFAULT_IP;
        }
        for (String ip : ipSources) {
            if (IpUtil.invalidOrInternalIp(ip)) continue;
            return ip;
        }
        return DEFAULT_IP;
    }

    private static boolean invalidOrInternalIp(String ip) {
        String[] ipSegs;
        int ipSeg2;
        if (!VALIDATOR.isValidInet4Address(ip)) {
            return true;
        }
        if (ip.startsWith("127.") || ip.startsWith("10.") || ip.startsWith("192.168.") || DEFAULT_IP.equals(ip)) {
            return true;
        }
        return ip.startsWith("172.") && (ipSeg2 = Integer.parseInt((ipSegs = ip.split("\\."))[1])) >= 16 && ipSeg2 <= 31;
    }
}

