/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtils {
    private static final String CONFIG = "config.properties";
    private static Log log = LogFactory.getLog(PropertyUtils.class);
    private static Map<String, String> configMap = new HashMap<String, String>();

    public static String getProperty(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        return configMap.get(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return StringUtils.isEmpty((CharSequence)defaultValue) ? null : defaultValue;
        }
        return StringUtils.isEmpty((CharSequence)configMap.get(key)) ? defaultValue : configMap.get(key);
    }

    public static int getPropertyIntValue(String key, int defaultValue) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return defaultValue;
        }
        return StringUtils.isEmpty((CharSequence)configMap.get(key)) || !PropertyUtils.isInt(configMap.get(key)) ? defaultValue : Integer.parseInt(configMap.get(key));
    }

    private static boolean isInt(String n) {
        try {
            Integer.parseInt(n);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static void load(String name) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        Properties p = new Properties();
        try {
            if (is != null) {
                p.load(is);
            }
            if (CONFIG.equals(name)) {
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    configMap.put((String)e.getKey(), (String)e.getValue());
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("load property file failed. file name: " + name), (Throwable)e);
        }
    }

    static {
        PropertyUtils.load(CONFIG);
    }
}

