/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class RandomUtil {
    public static final int MAX_BALL_NUMS = 100;

    private RandomUtil() {
    }

    public static String generateRandomCode(int maxValue, boolean autoCompleteZero) {
        Random r = new Random();
        int ball = r.nextInt(maxValue) + 1;
        if (autoCompleteZero && ball < 10) {
            return "0" + ball;
        }
        return Integer.toString(ball);
    }

    public static String generateRandomCodeContanisZero(int maxValue, boolean autoCompleteZero) {
        Random r = new Random();
        int ball = r.nextInt(++maxValue);
        if (autoCompleteZero && ball < 10) {
            return "0" + ball;
        }
        return Integer.toString(ball);
    }

    public static String generateRandomCodeString(int maxValue, boolean autoCompleteZero, int length, boolean duplicateEnable) {
        if (length > 100 || length < 0) {
            return "";
        }
        ArrayList<String> rBallList = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            String selectedBall = RandomUtil.generateRandomCode(maxValue, autoCompleteZero);
            if (!duplicateEnable && rBallList.contains(selectedBall)) {
                --i;
                continue;
            }
            rBallList.add(selectedBall);
        }
        Collections.sort(rBallList);
        StringBuilder result = new StringBuilder("");
        for (String rball : rBallList) {
            result = result.append(" ").append(rball);
        }
        return result.toString().substring(1);
    }

    public static String generateRandomCodeString(int maxValue, boolean autoCompleteZero, int length, boolean duplicateEnable, boolean containsZero) {
        if (length > 100 || length < 0) {
            return "";
        }
        ArrayList<String> rBallList = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            String selectedBall = containsZero ? RandomUtil.generateRandomCodeContanisZero(maxValue, autoCompleteZero) : RandomUtil.generateRandomCode(maxValue, autoCompleteZero);
            if (!duplicateEnable && rBallList.contains(selectedBall)) {
                --i;
                continue;
            }
            rBallList.add(selectedBall);
        }
        Collections.sort(rBallList);
        StringBuilder result = new StringBuilder("");
        for (String rball : rBallList) {
            result = result.append(" ").append(rball);
        }
        return result.toString().substring(1);
    }

    public static String generateRandomCodeStrOfSSC(int maxValue, boolean autoCompleteZero, int length, boolean duplicateEnable) {
        if (length > 100 || length < 0) {
            return "";
        }
        ArrayList<String> rBallList = new ArrayList<String>();
        Random r = new Random();
        for (int i = 0; i < length; ++i) {
            String selectedBall = Integer.toString(r.nextInt(maxValue));
            if (!duplicateEnable && rBallList.contains(selectedBall)) {
                --i;
                continue;
            }
            rBallList.add(selectedBall);
        }
        Collections.sort(rBallList);
        StringBuilder result = new StringBuilder("");
        for (String rball : rBallList) {
            result = result.append(" ").append(rball);
        }
        return result.toString().substring(1);
    }

    public static String generateRandomCodeStrOfDXDS(int maxValue, boolean autoCompleteZero, int length, boolean duplicateEnable) {
        if (length > 100 || length < 0) {
            return "";
        }
        ArrayList<String> rBallList = new ArrayList<String>();
        String[] dxds = new String[]{"2", "1", "5", "4"};
        for (int i = 0; i < length; ++i) {
            String selectedBall = RandomUtil.generateRandomCode(maxValue, autoCompleteZero);
            if (Integer.parseInt(selectedBall) > 4) {
                --i;
                continue;
            }
            if (!duplicateEnable && rBallList.contains(selectedBall)) {
                --i;
                continue;
            }
            rBallList.add(dxds[Integer.parseInt(selectedBall) - 1]);
        }
        Collections.sort(rBallList);
        StringBuilder result = new StringBuilder("");
        for (String rball : rBallList) {
            result = result.append(" ").append(rball);
        }
        return result.toString().substring(1);
    }

    public static int getRandomBetween(int min, int max) {
        if (min == max) {
            throw new IllegalArgumentException("min shouldn't equal max!");
        }
        Random random = new Random();
        return min + random.nextInt(Math.abs(max - min));
    }

    public static boolean hitByProbability(int probability) {
        return RandomUtil.hitByProbability(probability, new Random());
    }

    public static boolean hitByProbability(int probability, Random random) {
        if (probability < 0) {
            probability = 0;
        } else if (probability > 100) {
            probability = 100;
        }
        int rand = random.nextInt(100);
        return rand < probability;
    }
}

