/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.security.SecureRandom;

public class RandomUuidFactory {
    private static final RandomUuidFactory _SINGLETON = new RandomUuidFactory();
    private static final char[] _HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final SecureRandom _RNG = new SecureRandom();
    private static final int N = 16;

    private RandomUuidFactory() {
    }

    public static RandomUuidFactory getInstance() {
        return _SINGLETON;
    }

    public String createUUID() {
        return this.createUUID(16);
    }

    public String createUUID(int i) {
        if (i < 1 || i > 128) {
            throw new RuntimeException("invalid param:" + i);
        }
        int ii = (i + 1) / 2;
        byte[] bytes = new byte[ii];
        _RNG.nextBytes(bytes);
        StringBuffer uuid = new StringBuffer(i + 2);
        for (int n = 0; n < ii; ++n) {
            int hex = bytes[n] & 0xFF;
            uuid.append(_HEX_VALUES[hex >> 4]);
            uuid.append(_HEX_VALUES[hex & 0xF]);
        }
        return uuid.substring(uuid.length() - i);
    }
}

