/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SlidingWindow {
    private final int timeSliceSize;
    private final long timeMillisPerSlice;
    private final int windowSize;
    private AtomicInteger[] timeSlices;
    private Semaphore semaphore = new Semaphore(0);
    private AtomicInteger cursor = new AtomicInteger(0);

    public SlidingWindow(int windowSize, Time timeSlice) {
        this.timeMillisPerSlice = timeSlice.millis;
        this.windowSize = windowSize;
        this.timeSliceSize = windowSize * 2 + 1;
        this.init();
    }

    private void init() {
        AtomicInteger[] localTimeSlices = new AtomicInteger[this.timeSliceSize];
        for (int i = 0; i < this.timeSliceSize; ++i) {
            localTimeSlices[i] = new AtomicInteger(0);
        }
        this.timeSlices = localTimeSlices;
    }

    private int locationIndex() {
        long time = System.currentTimeMillis();
        return (int)(time / this.timeMillisPerSlice % (long)this.timeSliceSize);
    }

    private boolean allow(int threshold) {
        int index = this.locationIndex();
        int sum = 0;
        int oldCursor = this.cursor.getAndSet(index);
        if (oldCursor != index) {
            this.timeSlices[index].set(0);
            this.clearBetween(oldCursor, index);
        }
        for (int i = 0; i < this.windowSize; ++i) {
            sum += this.timeSlices[(index - i + this.timeSliceSize) % this.timeSliceSize].get();
        }
        if (sum < threshold) {
            this.timeSlices[index].incrementAndGet();
            this.semaphore.release(threshold - 1 - sum);
            return true;
        }
        return false;
    }

    public void await(int threshold) throws InterruptedException {
        while (!this.allow(threshold)) {
            this.semaphore.tryAcquire(50L, TimeUnit.MILLISECONDS);
        }
    }

    private void clearBetween(int fromIndex, int toIndex) {
        int index = (fromIndex + 1) % this.timeSliceSize;
        while (index != toIndex) {
            this.timeSlices[index].set(0);
            index = (index + 1) % this.timeSliceSize;
        }
    }

    public static enum Time {
        MILLISECONDS(1L),
        SECONDS(1000L),
        MINUTES(SECONDS.getMillis() * 60L),
        HOURS(MINUTES.getMillis() * 60L),
        DAYS(HOURS.getMillis() * 24L),
        WEEKS(DAYS.getMillis() * 7L);

        private long millis;

        private Time(long millis) {
            this.millis = millis;
        }

        public long getMillis() {
            return this.millis;
        }
    }
}

