/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextSimilarityUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(TextSimilarityUtil.class);
    private static final List<String> MATCHED_WORDS = List.of("ADJEI-AGYEI", "AGYEI-ADJEI", "ABDUL-ABUDU", "ABUDU-ABDUL", "JUNIOR-JNR", "JNR-JUNIOR");

    public static int getDameLevenDistance(CharSequence source, CharSequence target) {
        int i;
        if (source == null || target == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        int sourceLength = source.length();
        int targetLength = target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        int[][] dist = new int[sourceLength + 1][targetLength + 1];
        for (i = 0; i < sourceLength + 1; ++i) {
            dist[i][0] = i;
        }
        for (int j = 0; j < targetLength + 1; ++j) {
            dist[0][j] = j;
        }
        for (i = 1; i < sourceLength + 1; ++i) {
            for (int j = 1; j < targetLength + 1; ++j) {
                int cost = source.charAt(i - 1) == target.charAt(j - 1) ? 0 : 1;
                dist[i][j] = Math.min(Math.min(dist[i - 1][j] + 1, dist[i][j - 1] + 1), dist[i - 1][j - 1] + cost);
                if (i <= 1 || j <= 1 || source.charAt(i - 1) != target.charAt(j - 2) || source.charAt(i - 2) != target.charAt(j - 1)) continue;
                dist[i][j] = Math.min(dist[i][j], dist[i - 2][j - 2] + cost);
            }
        }
        return dist[sourceLength][targetLength];
    }

    public static boolean judgeStringSimilarity(String str1, String str2, Float strSimilarity) {
        if (MATCHED_WORDS.contains(str1 + "-" + str2)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)str1) && StringUtils.isBlank((CharSequence)str2)) {
            return false;
        }
        str1 = str1 == null ? "" : str1;
        str2 = str2 == null ? "" : str2;
        str1 = str1.contains("deviceId") ? str1.substring(0, str1.lastIndexOf("deviceId")) : str1;
        str2 = str2.contains("deviceId") ? str2.substring(0, str1.lastIndexOf("deviceId")) : str2;
        str1 = str1.replaceAll("Mozilla", "").replaceAll("AppleWebKit", "").replaceAll("KHTML", "").replaceAll("like Gecko", "").replaceAll(" network\\/([a-z])+", "");
        str2 = str2.replaceAll("Mozilla", "").replaceAll("AppleWebKit", "").replaceAll("KHTML", "").replaceAll("like Gecko", "").replaceAll(" network\\/([a-z])+", "");
        int distance = TextSimilarityUtil.getDameLevenDistance(str1, str2);
        float ratio = (float)(Math.max(str1.length(), str2.length()) - distance) / (float)Math.max(str1.length(), str2.length());
        log.debug("the similarity of between {} and {} is {}", (Object)str1, (Object)str2, (Object)Float.valueOf(ratio));
        return ratio >= strSimilarity.floatValue();
    }
}

