/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.common.utils;

import cn.hutool.crypto.digest.MD5;
import io.github.opensabe.common.utils.MD5Util;
import io.github.opensabe.common.utils.json.JsonUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ThirdPartySignatureUtil {
    private static final char SPLIT = '|';

    private static String generateRequestBody(Object requestBody) {
        if (Objects.isNull(requestBody)) {
            return null;
        }
        if (requestBody instanceof String) {
            String str = (String)requestBody;
            if (str.trim().startsWith("[") || str.trim().startsWith("{")) {
                return MD5.create().digestHex(JsonUtil.toJSONBytes((Object)str));
            }
            return MD5Util.md5WithoutSalt(str);
        }
        if (requestBody instanceof byte[]) {
            return MD5.create().digestHex((byte[])requestBody);
        }
        return MD5.create().digestHex(JsonUtil.toJSONBytes((Object)requestBody));
    }

    public static String generateSignature(String hashKey, String method, Object requestBody) {
        Object result = ThirdPartySignatureUtil.generateRequestBody(requestBody);
        result = StringUtils.isEmpty((CharSequence)result) ? hashKey + "|" + method + "|" : hashKey + "|" + method + "|" + (String)result;
        return MD5Util.md5WithoutSalt((String)result);
    }

    public static String generateThirdPartySignature(String hashKey, String method, String requestBody) {
        requestBody = StringUtils.isEmpty((CharSequence)requestBody) ? hashKey + "|" + method + "|" : hashKey + "|" + method + "|" + (String)requestBody;
        return MD5Util.md5WithoutSalt((String)requestBody);
    }

    public static boolean verifySignature(String requestSignature, String message) {
        return StringUtils.equals((CharSequence)message, (CharSequence)requestSignature);
    }

    public static void main(String[] args) {
        HashMap<String, Serializable> m1 = new HashMap<String, Serializable>();
        HashMap<String, Serializable> m2 = new HashMap<String, Serializable>();
        m1.put("a", Integer.valueOf(1));
        m1.put("b", Integer.valueOf(3));
        m2.put("b", Integer.valueOf(3));
        m2.put("a", Integer.valueOf(1));
        m1.put("c", m2);
        m2.put("c", m1);
        System.out.println(ThirdPartySignatureUtil.generateRequestBody(m1));
        System.out.println(ThirdPartySignatureUtil.generateRequestBody(m2));
    }
}

