/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractMapper {
    private final String packageName;
    private final Set<String> imports = new HashSet<String>();
    private final String sourceName;
    private final String sourceClass;
    private final String mapperName;
    private final boolean cycle;

    protected AbstractMapper(String packageName, String sourceClass, String mapperName, boolean cycle) {
        this.packageName = packageName;
        this.sourceClass = sourceClass;
        this.mapperName = mapperName;
        this.sourceName = this.classSimpleName(sourceClass);
        this.cycle = cycle;
        this.addImports(sourceClass);
    }

    public String getTargetClass() {
        return "";
    }

    protected void addImports(String imports) {
        this.imports.add(imports);
    }

    protected void addImports(List<String> imports) {
        this.imports.addAll(imports);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    protected String classSimpleName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    String template() {
        return this.getClass().getSimpleName() + "Generator.ftl";
    }
}

