/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import io.github.opensabe.mapstruct.core.CommonCopyMapper;
import io.github.opensabe.mapstruct.core.FromMapMapper;
import io.github.opensabe.mapstruct.core.MapperRegister;
import io.github.opensabe.mapstruct.processor.CustomerMapper;
import io.github.opensabe.mapstruct.processor.FreeMarkerProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.Mapper;

@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@SupportedAnnotationTypes(value={"io.github.opensabe.mapstruct.core.RegisterRepository"})
public class CustomerRegisterProcessor
extends FreeMarkerProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private TypeMirror commonMirror;
    private TypeMirror mapMirror;
    private boolean hasBinding = true;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        TypeElement typeElement = this.elementUtils.getTypeElement(CommonCopyMapper.class.getName());
        if (typeElement == null) {
            this.hasBinding = false;
        } else {
            this.commonMirror = this.typeUtils.erasure(typeElement.asType());
            this.mapMirror = this.typeUtils.erasure(this.elementUtils.getTypeElement(FromMapMapper.class.getName()).asType());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.hasBinding) {
            return false;
        }
        ArrayList mappers = new ArrayList();
        if (!roundEnv.processingOver() && !annotations.isEmpty()) {
            for (TypeElement typeElement : annotations) {
                this.messager.printNote("------- resolve annotation [io.github.opensabe.mapstruct.core.RegisterRepository] -------------");
                Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : set) {
                    if (!this.hasMapperAnnotation(element) || !(element instanceof TypeElement)) continue;
                    TypeElement typeElement2 = (TypeElement)element;
                    typeElement2.getInterfaces().stream().filter(this::isSubtype).filter(m -> m instanceof DeclaredType).findFirst().ifPresent(m -> {
                        List<? extends TypeMirror> arguments = ((DeclaredType)m).getTypeArguments();
                        if (arguments.size() == 2) {
                            mappers.add(new CustomerMapper(mapper2.toString(), arguments.getFirst().toString(), arguments.get(1).toString()));
                        } else {
                            mappers.add(new CustomerMapper(mapper2.toString(), null, arguments.getFirst().toString()));
                        }
                    });
                }
            }
            if (!mappers.isEmpty()) {
                mappers.forEach(mapper -> this.messager.printNote("[io.github.opensabe.mapstruct.core.RegisterRepository] find mapper [%s]".formatted(mapper.getMapperClass())));
                TypeElement interfaceName = this.elementUtils.getTypeElement(MapperRegister.class.getName());
                String string = interfaceName.toString() + "Impl";
                this.writeClass(string, MapperRegister.class.getSimpleName() + ".ftl", Map.of("mappers", mappers));
            }
        }
        return false;
    }

    private boolean isSubtype(TypeMirror type) {
        return this.typeUtils.isSubtype(type, this.mapMirror) || this.typeUtils.isSubtype(type, this.commonMirror);
    }

    private boolean hasMapperAnnotation(Element mapper) {
        return this.elementUtils.getAllAnnotationMirrors(mapper).stream().anyMatch(a -> this.typeUtils.isSameType(this.elementUtils.getTypeElement(Mapper.class.getName()).asType(), a.getAnnotationType()));
    }
}

