/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.node.manager;

import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public abstract class AbstractBaseOnNodeManagerInitializer
implements ApplicationListener<ApplicationStartedEvent>,
Ordered {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    static boolean isBootstrapContext(ApplicationStartedEvent applicationEvent) {
        return applicationEvent.getApplicationContext().getEnvironment().getPropertySources().contains("bootstrap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (AbstractBaseOnNodeManagerInitializer.isBootstrapContext(event)) {
            return;
        }
        AtomicBoolean atomicBoolean = INITIALIZED;
        synchronized (atomicBoolean) {
            if (INITIALIZED.get()) {
                return;
            }
            this.init();
            INITIALIZED.set(true);
        }
    }

    protected abstract void init();

    public int getOrder() {
        return -2147483647;
    }
}

