/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.node.manager;

import io.github.opensabe.common.utils.json.JsonUtil;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class CurrentCandidateManager {
    @Generated
    private static final Logger log = LogManager.getLogger(CurrentCandidateManager.class);
    private final DiscoveryClient discoveryClient;
    private final String serviceId;
    private final String instanceId;

    public CurrentCandidateManager(DiscoveryClient discoveryClient, String serviceId, String instanceId) {
        this.discoveryClient = discoveryClient;
        this.serviceId = serviceId;
        this.instanceId = instanceId;
    }

    public boolean isLeader(Comparator<ServiceInstance> instanceComparator) {
        List instances = this.discoveryClient.getInstances(this.serviceId);
        List sorted = instances.stream().sorted(instanceComparator).collect(Collectors.toList());
        log.info("CurrentCandidateManager-isLeader: candidates: {}, sorted: {}, current instanceId: {}", (Object)JsonUtil.toJSONString((Object)instances), (Object)JsonUtil.toJSONString(sorted), (Object)this.instanceId);
        if (CollectionUtils.isNotEmpty(sorted)) {
            return StringUtils.endsWithIgnoreCase((String)((ServiceInstance)sorted.get(0)).getInstanceId(), (String)this.instanceId);
        }
        return false;
    }
}

