/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.node.manager;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.StringRedisTemplate;

public class NodeManager {
    @Generated
    private static final Logger log = LogManager.getLogger(NodeManager.class);
    public static final String PATH = "/actuator/node-id";
    private final RedissonClient redissonClient;
    private final StringRedisTemplate redisTemplate;
    private final String serviceId;
    private final String instanceId;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private volatile int nodeId = -1;

    public NodeManager(RedissonClient redissonClient, StringRedisTemplate redisTemplate, String serviceId, String instanceId) {
        this.redissonClient = redissonClient;
        this.redisTemplate = redisTemplate;
        this.serviceId = serviceId;
        this.instanceId = instanceId;
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
    }

    private String getLockName() {
        return "spring:node:manager:lock:" + this.serviceId;
    }

    private String getKey(int nodeId) {
        return "spring:node:manager:" + this.serviceId + ":" + nodeId;
    }

    void init() {
        try {
            this.lock();
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                String key = this.getKey(i);
                String s = (String)this.redisTemplate.opsForValue().get((Object)key);
                if (StringUtils.isNotBlank((String)s)) {
                    log.info("node {} is occupied by {}", (Object)i, (Object)s);
                    continue;
                }
                Boolean ifAbsent = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)this.instanceId, 10L, TimeUnit.SECONDS);
                if (!ifAbsent.booleanValue()) continue;
                this.nodeId = i;
                log.info("successfully occupied {}->{}", (Object)i, (Object)this.instanceId);
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
                    try {
                        this.redisTemplate.opsForValue().set((Object)key, (Object)this.instanceId, 10L, TimeUnit.SECONDS);
                    }
                    catch (Throwable e) {
                        log.warn("reset node manager key: {} error", (Object)this.nodeId, (Object)e.getMessage());
                    }
                }, 1L, 1L, TimeUnit.SECONDS);
                return;
            }
            throw new IllegalStateException("cannot get node id");
        }
        finally {
            this.unLock();
        }
    }

    private void lock() {
        RLock lock = this.redissonClient.getLock(this.getLockName());
        log.info("try to acquire node lock");
        lock.lock(1L, TimeUnit.MINUTES);
        log.info("node lock acquired");
    }

    private void unLock() {
        RLock lock = this.redissonClient.getLock(this.getLockName());
        log.info("try to release node lock");
        lock.unlock();
        log.info("node lock released");
    }

    @Generated
    public int getNodeId() {
        return this.nodeId;
    }

    private static class NodeResponseVO {
        private int bizCode;
        private String innerMsg;
        private String message;
        private int data;

        @Generated
        public NodeResponseVO() {
        }

        @Generated
        public int getBizCode() {
            return this.bizCode;
        }

        @Generated
        public String getInnerMsg() {
            return this.innerMsg;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public int getData() {
            return this.data;
        }

        @Generated
        public void setBizCode(int bizCode) {
            this.bizCode = bizCode;
        }

        @Generated
        public void setInnerMsg(String innerMsg) {
            this.innerMsg = innerMsg;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setData(int data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeResponseVO)) {
                return false;
            }
            NodeResponseVO other = (NodeResponseVO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBizCode() != other.getBizCode()) {
                return false;
            }
            if (this.getData() != other.getData()) {
                return false;
            }
            String this$innerMsg = this.getInnerMsg();
            String other$innerMsg = other.getInnerMsg();
            if (this$innerMsg == null ? other$innerMsg != null : !this$innerMsg.equals(other$innerMsg)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NodeResponseVO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBizCode();
            result = result * 59 + this.getData();
            String $innerMsg = this.getInnerMsg();
            result = result * 59 + ($innerMsg == null ? 43 : $innerMsg.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NodeManager.NodeResponseVO(bizCode=" + this.getBizCode() + ", innerMsg=" + this.getInnerMsg() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
        }
    }
}

