/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.node.manager;

import io.github.opensabe.node.manager.AbstractBaseOnNodeManagerInitializer;
import io.github.opensabe.node.manager.NodeManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class NodeManagerInitializeListener
implements ApplicationListener<ApplicationStartedEvent>,
Ordered {
    public static final int ORDER = Integer.MIN_VALUE;
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (AbstractBaseOnNodeManagerInitializer.isBootstrapContext(event)) {
            return;
        }
        AtomicBoolean atomicBoolean = INITIALIZED;
        synchronized (atomicBoolean) {
            if (INITIALIZED.get()) {
                return;
            }
            NodeManager nodeManager = (NodeManager)event.getApplicationContext().getBean(NodeManager.class);
            nodeManager.init();
            INITIALIZED.set(true);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

