package io.github.optimumcode.json.schema.`internal`.unicode

import io.github.optimumcode.json.schema.`internal`.unicode.categories.ClosePunctuation
import io.github.optimumcode.json.schema.`internal`.unicode.categories.ConnectorPunctuation
import io.github.optimumcode.json.schema.`internal`.unicode.categories.Control
import io.github.optimumcode.json.schema.`internal`.unicode.categories.CurrencySymbol
import io.github.optimumcode.json.schema.`internal`.unicode.categories.DashPunctuation
import io.github.optimumcode.json.schema.`internal`.unicode.categories.DecimalNumber
import io.github.optimumcode.json.schema.`internal`.unicode.categories.EnclosingMark
import io.github.optimumcode.json.schema.`internal`.unicode.categories.FinalPunctuation
import io.github.optimumcode.json.schema.`internal`.unicode.categories.Format
import io.github.optimumcode.json.schema.`internal`.unicode.categories.InitialPunctuation
import io.github.optimumcode.json.schema.`internal`.unicode.categories.LetterNumber
import io.github.optimumcode.json.schema.`internal`.unicode.categories.LineSeparator
import io.github.optimumcode.json.schema.`internal`.unicode.categories.LowercaseLetter
import io.github.optimumcode.json.schema.`internal`.unicode.categories.MathSymbol
import io.github.optimumcode.json.schema.`internal`.unicode.categories.ModifierLetter
import io.github.optimumcode.json.schema.`internal`.unicode.categories.ModifierSymbol
import io.github.optimumcode.json.schema.`internal`.unicode.categories.NonspacingMark
import io.github.optimumcode.json.schema.`internal`.unicode.categories.OpenPunctuation
import io.github.optimumcode.json.schema.`internal`.unicode.categories.OtherLetter
import io.github.optimumcode.json.schema.`internal`.unicode.categories.OtherNumber
import io.github.optimumcode.json.schema.`internal`.unicode.categories.OtherPunctuation
import io.github.optimumcode.json.schema.`internal`.unicode.categories.OtherSymbol
import io.github.optimumcode.json.schema.`internal`.unicode.categories.ParagraphSeparator
import io.github.optimumcode.json.schema.`internal`.unicode.categories.PrivateUse
import io.github.optimumcode.json.schema.`internal`.unicode.categories.SpaceSeparator
import io.github.optimumcode.json.schema.`internal`.unicode.categories.SpacingMark
import io.github.optimumcode.json.schema.`internal`.unicode.categories.Surrrogate
import io.github.optimumcode.json.schema.`internal`.unicode.categories.TitlecaseLetter
import io.github.optimumcode.json.schema.`internal`.unicode.categories.UppercaseLetter

internal enum class CharacterCategory(
  public val characterData: CharacterCategoryData,
) {
  /**
   * Control category "Cc" in unicode
   */
  CONTROL(Control),
  /**
   * Format category "Cf" in unicode
   */
  FORMAT(Format),
  /**
   * Private Use category "Co" in unicode
   */
  PRIVATE_USE(PrivateUse),
  /**
   * Surrrogate category "Cs" in unicode
   */
  SURRROGATE(Surrrogate),
  /**
   * Lowercase Letter category "Ll" in unicode
   */
  LOWERCASE_LETTER(LowercaseLetter),
  /**
   * Modifier Letter category "Lm" in unicode
   */
  MODIFIER_LETTER(ModifierLetter),
  /**
   * Other Letter category "Lo" in unicode
   */
  OTHER_LETTER(OtherLetter),
  /**
   * Titlecase Letter category "Lt" in unicode
   */
  TITLECASE_LETTER(TitlecaseLetter),
  /**
   * Uppercase Letter category "Lu" in unicode
   */
  UPPERCASE_LETTER(UppercaseLetter),
  /**
   * Spacing Mark category "Mc" in unicode
   */
  SPACING_MARK(SpacingMark),
  /**
   * Enclosing Mark category "Me" in unicode
   */
  ENCLOSING_MARK(EnclosingMark),
  /**
   * Nonspacing Mark category "Mn" in unicode
   */
  NONSPACING_MARK(NonspacingMark),
  /**
   * Decimal Number category "Nd" in unicode
   */
  DECIMAL_NUMBER(DecimalNumber),
  /**
   * Letter Number category "Nl" in unicode
   */
  LETTER_NUMBER(LetterNumber),
  /**
   * Other Number category "No" in unicode
   */
  OTHER_NUMBER(OtherNumber),
  /**
   * Connector Punctuation category "Pc" in unicode
   */
  CONNECTOR_PUNCTUATION(ConnectorPunctuation),
  /**
   * Dash Punctuation category "Pd" in unicode
   */
  DASH_PUNCTUATION(DashPunctuation),
  /**
   * Close Punctuation category "Pe" in unicode
   */
  CLOSE_PUNCTUATION(ClosePunctuation),
  /**
   * Final Punctuation category "Pf" in unicode
   */
  FINAL_PUNCTUATION(FinalPunctuation),
  /**
   * Initial Punctuation category "Pi" in unicode
   */
  INITIAL_PUNCTUATION(InitialPunctuation),
  /**
   * Other Punctuation category "Po" in unicode
   */
  OTHER_PUNCTUATION(OtherPunctuation),
  /**
   * Open Punctuation category "Ps" in unicode
   */
  OPEN_PUNCTUATION(OpenPunctuation),
  /**
   * Currency Symbol category "Sc" in unicode
   */
  CURRENCY_SYMBOL(CurrencySymbol),
  /**
   * Modifier Symbol category "Sk" in unicode
   */
  MODIFIER_SYMBOL(ModifierSymbol),
  /**
   * Math Symbol category "Sm" in unicode
   */
  MATH_SYMBOL(MathSymbol),
  /**
   * Other Symbol category "So" in unicode
   */
  OTHER_SYMBOL(OtherSymbol),
  /**
   * Line Separator category "Zl" in unicode
   */
  LINE_SEPARATOR(LineSeparator),
  /**
   * Paragraph Separator category "Zp" in unicode
   */
  PARAGRAPH_SEPARATOR(ParagraphSeparator),
  /**
   * Space Separator category "Zs" in unicode
   */
  SPACE_SEPARATOR(SpaceSeparator),
  ;
}
