package io.github.optimumcode.json.schema.`internal`.unicode

import io.github.optimumcode.json.schema.`internal`.unicode.classes.ArabicLetter
import io.github.optimumcode.json.schema.`internal`.unicode.classes.ArabicNumber
import io.github.optimumcode.json.schema.`internal`.unicode.classes.BoundaryNeutral
import io.github.optimumcode.json.schema.`internal`.unicode.classes.CommonSeparator
import io.github.optimumcode.json.schema.`internal`.unicode.classes.EuropeanNumber
import io.github.optimumcode.json.schema.`internal`.unicode.classes.EuropeanSeparator
import io.github.optimumcode.json.schema.`internal`.unicode.classes.EuropeanTerminator
import io.github.optimumcode.json.schema.`internal`.unicode.classes.FirstStrongIsolate
import io.github.optimumcode.json.schema.`internal`.unicode.classes.LeftToRight
import io.github.optimumcode.json.schema.`internal`.unicode.classes.LeftToRightEmbedding
import io.github.optimumcode.json.schema.`internal`.unicode.classes.LeftToRightIsolate
import io.github.optimumcode.json.schema.`internal`.unicode.classes.LeftToRightOverride
import io.github.optimumcode.json.schema.`internal`.unicode.classes.NonspacingMark
import io.github.optimumcode.json.schema.`internal`.unicode.classes.OtherNeutral
import io.github.optimumcode.json.schema.`internal`.unicode.classes.ParagraphSeparator
import io.github.optimumcode.json.schema.`internal`.unicode.classes.PopDirectionalFormat
import io.github.optimumcode.json.schema.`internal`.unicode.classes.PopDirectionalIsolate
import io.github.optimumcode.json.schema.`internal`.unicode.classes.RightToLeft
import io.github.optimumcode.json.schema.`internal`.unicode.classes.RightToLeftEmbedding
import io.github.optimumcode.json.schema.`internal`.unicode.classes.RightToLeftIsolate
import io.github.optimumcode.json.schema.`internal`.unicode.classes.RightToLeftOverride
import io.github.optimumcode.json.schema.`internal`.unicode.classes.SegmentSeparator
import io.github.optimumcode.json.schema.`internal`.unicode.classes.WhiteSpace

internal enum class CharacterDirectionality(
  public val characterData: CharacterDirectionData,
) {
  /**
   * Arabic Letter type "AL" in unicode
   */
  ARABIC_LETTER(ArabicLetter),
  /**
   * Arabic Number type "AN" in unicode
   */
  ARABIC_NUMBER(ArabicNumber),
  /**
   * Paragraph Separator type "B" in unicode
   */
  PARAGRAPH_SEPARATOR(ParagraphSeparator),
  /**
   * Boundary Neutral type "BN" in unicode
   */
  BOUNDARY_NEUTRAL(BoundaryNeutral),
  /**
   * Common Separator type "CS" in unicode
   */
  COMMON_SEPARATOR(CommonSeparator),
  /**
   * European Number type "EN" in unicode
   */
  EUROPEAN_NUMBER(EuropeanNumber),
  /**
   * European Separator type "ES" in unicode
   */
  EUROPEAN_SEPARATOR(EuropeanSeparator),
  /**
   * European Terminator type "ET" in unicode
   */
  EUROPEAN_TERMINATOR(EuropeanTerminator),
  /**
   * First Strong Isolate type "FSI" in unicode
   */
  FIRST_STRONG_ISOLATE(FirstStrongIsolate),
  /**
   * Left To Right type "L" in unicode
   */
  LEFT_TO_RIGHT(LeftToRight),
  /**
   * Left To Right Embedding type "LRE" in unicode
   */
  LEFT_TO_RIGHT_EMBEDDING(LeftToRightEmbedding),
  /**
   * Left To Right Isolate type "LRI" in unicode
   */
  LEFT_TO_RIGHT_ISOLATE(LeftToRightIsolate),
  /**
   * Left To Right Override type "LRO" in unicode
   */
  LEFT_TO_RIGHT_OVERRIDE(LeftToRightOverride),
  /**
   * Nonspacing Mark type "NSM" in unicode
   */
  NONSPACING_MARK(NonspacingMark),
  /**
   * Other Neutral type "ON" in unicode
   */
  OTHER_NEUTRAL(OtherNeutral),
  /**
   * Pop Directional Format type "PDF" in unicode
   */
  POP_DIRECTIONAL_FORMAT(PopDirectionalFormat),
  /**
   * Pop Directional Isolate type "PDI" in unicode
   */
  POP_DIRECTIONAL_ISOLATE(PopDirectionalIsolate),
  /**
   * Right To Left type "R" in unicode
   */
  RIGHT_TO_LEFT(RightToLeft),
  /**
   * Right To Left Embedding type "RLE" in unicode
   */
  RIGHT_TO_LEFT_EMBEDDING(RightToLeftEmbedding),
  /**
   * Right To Left Isolate type "RLI" in unicode
   */
  RIGHT_TO_LEFT_ISOLATE(RightToLeftIsolate),
  /**
   * Right To Left Override type "RLO" in unicode
   */
  RIGHT_TO_LEFT_OVERRIDE(RightToLeftOverride),
  /**
   * Segment Separator type "S" in unicode
   */
  SEGMENT_SEPARATOR(SegmentSeparator),
  /**
   * White Space type "WS" in unicode
   */
  WHITE_SPACE(WhiteSpace),
  ;
}
